/*
 * Decompiled with CFR 0.152.
 */
package com.wiley.compbooks.vogel.chapter12.loginBean;

import com.wiley.compbooks.vogel.chapter12.loginBean.LoginEventListener;
import com.wiley.compbooks.vogel.chapter12.loginBean.LoginEventObject;
import com.wiley.compbooks.vogel.chapter12.security.Authentication;
import com.wiley.compbooks.vogel.chapter12.security.AuthenticationHelper;
import com.wiley.compbooks.vogel.chapter12.security.NotAuthenticated;
import java.awt.Button;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.Vector;
import org.omg.CORBA.ORB;
import org.omg.CORBA.SystemException;

public class Login
extends Panel
implements Serializable,
ActionListener {
    private String welcomeString;
    private String rejectString;
    private String acceptString;
    private String failureString;
    private String idLabelString;
    private String passwdLabelString;
    private String loginButtonString = new String("login");
    private String authenticationName;
    private String authenticationHost;
    private transient Label messageLabel;
    private transient Label idLabel;
    private transient Label passwdLabel;
    private transient TextField idTextField;
    private transient TextField passwdTextField;
    private transient Button loginButton;
    private transient PropertyChangeSupport changes;
    private transient Vector loginEventListeners;
    private transient Authentication authentication;

    public Login() {
        this.welcomeString = new String("Please login");
        this.rejectString = new String("Not authenticated, please try again!");
        this.acceptString = new String("Authenticated!");
        this.failureString = new String("Security server not available, please try again later");
        this.idLabelString = new String("User id: ");
        this.passwdLabelString = new String("Password: ");
        this.authenticationName = new String("");
        this.authenticationHost = new String("");
        this.loginButton = new Button(this.loginButtonString);
        this.loginButton.setActionCommand("login");
        this.loginButton.addActionListener(this);
        this.idLabel = new Label(this.idLabelString);
        this.passwdLabel = new Label(this.passwdLabelString);
        this.idLabel = new Label(this.idLabelString);
        this.passwdLabel = new Label(this.passwdLabelString);
        this.messageLabel = new Label(this.welcomeString, 1);
        this.idTextField = new TextField(20);
        this.idTextField.setFont(new Font("Helvetica", 1, 14));
        this.passwdTextField = new TextField(20);
        this.passwdTextField.setEchoChar('*');
        this.passwdTextField.setFont(new Font("Helvetica", 1, 14));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.messageLabel, gridBagConstraints);
        this.add(this.messageLabel);
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.idLabel, gridBagConstraints);
        this.add(this.idLabel);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.idTextField, gridBagConstraints);
        this.add(this.idTextField);
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.passwdLabel, gridBagConstraints);
        this.add(this.passwdLabel);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.passwdTextField, gridBagConstraints);
        this.add(this.passwdTextField);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.loginButton, gridBagConstraints);
        this.add(this.loginButton);
        this.validate();
        this.changes = new PropertyChangeSupport(this);
        this.loginEventListeners = new Vector();
        try {
            ORB oRB = ORB.init();
            if (this.authenticationName.equals("") && this.authenticationHost.equals("")) {
                System.err.println("bind 0");
                this.authentication = AuthenticationHelper.bind((ORB)oRB);
                return;
            }
            if (!this.authenticationName.equals("")) {
                this.authentication = AuthenticationHelper.bind((ORB)oRB, (String)this.authenticationName);
                return;
            }
            this.authentication = AuthenticationHelper.bind((ORB)oRB, (String)this.authenticationName, (String)this.authenticationHost, null);
            return;
        }
        catch (SystemException systemException) {
            this.messageLabel.setText(this.failureString);
            return;
        }
    }

    public void login(String string, String string2) {
        try {
            this.authentication.authenticate(string, string2);
            this.messageLabel.setText(this.acceptString);
            ((TextComponent)this.passwdTextField).setText("");
            LoginEventObject loginEventObject = new LoginEventObject(this, string);
            int n = 0;
            while (n < this.loginEventListeners.size()) {
                LoginEventListener loginEventListener = (LoginEventListener)this.loginEventListeners.elementAt(n);
                loginEventListener.handleLoginEvent(loginEventObject);
                ++n;
            }
            return;
        }
        catch (NotAuthenticated notAuthenticated) {
            this.messageLabel.setText(this.rejectString);
            return;
        }
        catch (SystemException systemException) {
            this.messageLabel.setText(this.failureString);
            return;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("login")) {
            this.login(this.idTextField.getText(), this.passwdTextField.getText());
        }
    }

    public void addLoginEventListener(LoginEventListener loginEventListener) {
        this.loginEventListeners.addElement(loginEventListener);
    }

    public void removeLoginEventListener(LoginEventListener loginEventListener) {
        this.loginEventListeners.removeElement(loginEventListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.removePropertyChangeListener(propertyChangeListener);
    }

    public void setWelcomeString(String string) {
        this.changes.firePropertyChange("welcomeString", this.welcomeString, string);
        this.welcomeString = string;
        this.messageLabel.setText(this.welcomeString);
    }

    public String getWelcomeString() {
        return this.welcomeString;
    }

    public void setAcceptString(String string) {
        this.changes.firePropertyChange("acceptString", this.acceptString, string);
        this.acceptString = string;
    }

    public String getAcceptString() {
        return this.acceptString;
    }

    public void setRejectString(String string) {
        this.changes.firePropertyChange("rejectString", this.rejectString, string);
        this.rejectString = string;
    }

    public String getRejectString() {
        return this.rejectString;
    }

    public void setFailureString(String string) {
        this.changes.firePropertyChange("failureString", this.failureString, string);
        this.failureString = string;
    }

    public String getFailureString() {
        return this.failureString;
    }

    public void setIdLabelString(String string) {
        this.changes.firePropertyChange("idLabelString", this.idLabelString, string);
        this.idLabelString = string;
        this.idLabel.setText(this.idLabelString);
    }

    public String getIdLabelString() {
        return this.idLabelString;
    }

    public void setPasswdLabelString(String string) {
        this.changes.firePropertyChange("passwdLabelString", this.passwdLabelString, string);
        this.passwdLabelString = string;
        this.passwdLabel.setText(this.passwdLabelString);
    }

    public String getPasswdLabelString() {
        return this.passwdLabelString;
    }

    public void setLoginButtonString(String string) {
        this.changes.firePropertyChange("loginButtonString", this.loginButtonString, string);
        this.loginButtonString = string;
        this.loginButton.setLabel(this.loginButtonString);
    }

    public String getLoginButtonString() {
        return this.loginButtonString;
    }

    public void setAuthenticationName(String string) {
        this.changes.firePropertyChange("authenticationName", this.authenticationName, string);
        this.authenticationName = string;
    }

    public String getAuthenticationName() {
        return this.authenticationName;
    }

    public void setAuthenticationHost(String string) {
        this.changes.firePropertyChange("authenticationHost", this.authenticationHost, string);
        this.authenticationHost = string;
    }

    public String getAuthenticationHost() {
        return this.authenticationHost;
    }
}

