/*
 * Decompiled with CFR 0.152.
 */
package transport;

import common.Sink;
import common.Source;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.rmi.RemoteException;
import transport.HttpSink;
import transport.HttpSource;

public class Transport {
    Source source;

    public static Transport createTransport() {
        return new Transport();
    }

    public static boolean compatable(Source source, Sink sink) {
        return source instanceof HttpSource && sink instanceof HttpSink;
    }

    public InputStream getInputStream(Source source) {
        if (source instanceof HttpSource) {
            URLConnection uRLConnection = null;
            URL uRL = null;
            try {
                uRL = ((HttpSource)source).getHttpUrl().getURL();
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
                return null;
            }
            try {
                uRLConnection = uRL.openConnection();
                uRLConnection.setDoInput(true);
                uRLConnection.setDoOutput(false);
                return uRLConnection.getInputStream();
            }
            catch (IOException iOException) {
                System.err.println("Getting in stream " + iOException.toString());
                return null;
            }
        }
        return null;
    }
}

