/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.GUIClient;
import client.LabelCellRenderer;
import common.AlreadyPlayingException;
import common.AlreadyRecordingException;
import common.NoSuchListenerException;
import common.NotRecordingException;
import common.Sink;
import common.Source;
import common.SourceSink;
import common.VolumeControl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.rmi.MarshalledObject;
import java.rmi.Remote;
import java.rmi.RemoteException;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.jini.core.event.RemoteEvent;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.lookup.ServiceItem;

public class PlayFrame
extends JFrame
implements ActionListener,
ChangeListener,
RemoteEventListener {
    private ServiceItem[] sources;
    private ServiceItem sinkItem;
    private Sink sink;
    private Source source;
    private JList sourceList = new JList();
    private JButton stopBtn = new JButton("Stop");
    private JLabel sinkLabel = new JLabel();
    private JSlider sourceVolumeCtl = new JSlider();
    private JSlider sinkVolumeCtl = new JSlider();
    private DefaultListModel model;
    private Remote proxy;
    private GUIClient client;

    public PlayFrame(GUIClient gUIClient) {
        this.setTitle("Player");
        this.client = gUIClient;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.sinkLabel, "North");
        container.add((Component)this.sourceList, "Center");
        container.add((Component)jPanel, "South");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 2));
        jPanel2.add(this.sourceVolumeCtl);
        jPanel2.add(this.sinkVolumeCtl);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(1, 3));
        jPanel3.add(this.stopBtn);
        jPanel.add((Component)jPanel2, "North");
        jPanel.add((Component)jPanel3, "South");
        this.stopBtn.addActionListener(this);
        LabelCellRenderer labelCellRenderer = new LabelCellRenderer();
        this.sourceList.setCellRenderer(labelCellRenderer);
        this.model = new DefaultListModel();
        this.sourceList.setModel(this.model);
        this.sourceVolumeCtl.setEnabled(false);
        this.sinkVolumeCtl.setEnabled(false);
        this.sourceVolumeCtl.addChangeListener(this);
        this.sinkVolumeCtl.addChangeListener(this);
        this.sourceVolumeCtl.setToolTipText("Set volume on the source");
        this.sinkVolumeCtl.setToolTipText("Set volume on the sink");
        this.setSize(400, 300);
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.stopBtn) {
            try {
                this.sink.stop();
                this.sinkVolumeCtl.setEnabled(false);
                this.sourceVolumeCtl.setEnabled(false);
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
            }
            catch (NotRecordingException notRecordingException) {
                notRecordingException.printStackTrace();
            }
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        JSlider jSlider = (JSlider)changeEvent.getSource();
        int n = jSlider.getValue();
        VolumeControl volumeControl = null;
        if (jSlider == this.sinkVolumeCtl) {
            volumeControl = (VolumeControl)((Object)this.sink);
        } else if (jSlider == this.sourceVolumeCtl) {
            volumeControl = (VolumeControl)((Object)this.source);
        }
        try {
            volumeControl.setVolume(n);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void play(ServiceItem[] serviceItemArray, ServiceItem serviceItem) {
        if (serviceItemArray == null || serviceItemArray.length == 0) {
            System.out.println("Play: null sources");
            Runnable runnable = new Runnable(){

                public void run() {
                    PlayFrame.this.dispose();
                }
            };
            SwingUtilities.invokeLater(runnable);
            return;
        }
        this.sources = serviceItemArray;
        this.sinkItem = serviceItem;
        this.sink = (Sink)serviceItem.service;
        this.source = (Source)serviceItemArray[0].service;
        this.sinkLabel.setText("Playing to " + serviceItem.toString());
        this.model.clear();
        for (int i = 0; i < serviceItemArray.length; ++i) {
            this.model.addElement(serviceItemArray[i]);
        }
        ServiceItem[] serviceItemArray2 = new ServiceItem[serviceItemArray.length - 1];
        for (int i = 0; i < serviceItemArray2.length; ++i) {
            serviceItemArray2[i] = serviceItemArray[i + 1];
        }
        MarshalledObject<SourceSink> marshalledObject = null;
        try {
            marshalledObject = new MarshalledObject<SourceSink>(new SourceSink(serviceItemArray2, serviceItem));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        try {
            if (this.proxy == null) {
                this.proxy = this.client.export(this);
            }
            System.out.println("Added source " + this.source + " proxy " + this.proxy);
            this.sink.addSinkListener((RemoteEventListener)this.proxy, marshalledObject);
            System.out.println("Added sink " + this.sink + " proxy " + this.proxy + " handback " + marshalledObject.get().sources);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            System.out.println("Setting sink to: " + this.sink);
            this.source.addSink(this.sink);
            System.out.println("Setting source to: " + this.source);
            this.sink.addSource(this.source);
            System.out.println("Playing" + serviceItemArray[0].attributeSets[0]);
            this.source.play();
            this.sink.record();
        }
        catch (AlreadyPlayingException alreadyPlayingException) {
            JOptionPane.showMessageDialog(null, "Source already playing", "Play error", 0);
            return;
        }
        catch (AlreadyRecordingException alreadyRecordingException) {
            JOptionPane.showMessageDialog(null, "Sink already recording", "Record error", 0);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        System.out.println("Checking VC " + this.sink);
        if (this.source instanceof VolumeControl) {
            System.out.println("Source is VC");
            this.enableVolumeControl((VolumeControl)((Object)this.source), this.sourceVolumeCtl);
        }
        if (this.sink instanceof VolumeControl) {
            System.out.println("Sink is VC");
            this.enableVolumeControl((VolumeControl)((Object)this.sink), this.sinkVolumeCtl);
        }
    }

    public void notify(RemoteEvent remoteEvent) {
        Object object = remoteEvent.getSource();
        System.out.println("Updating " + object);
        if (object instanceof Sink && remoteEvent.getID() == 1L) {
            System.out.println("Sink stopped event");
            Sink sink = (Sink)object;
            try {
                sink.removeSinkListener((RemoteEventListener)this.proxy);
                System.out.println("Removed listener " + this.proxy);
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
            }
            catch (NoSuchListenerException noSuchListenerException) {
                System.err.println("Can't remove listener " + this.proxy);
            }
            MarshalledObject marshalledObject = remoteEvent.getRegistrationObject();
            SourceSink sourceSink = null;
            try {
                sourceSink = (SourceSink)marshalledObject.get();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
            final ServiceItem[] serviceItemArray = sourceSink.sources;
            final ServiceItem serviceItem = sourceSink.sink;
            System.out.println("  stop -> play: sources " + serviceItemArray + " sink " + sink);
            Runnable runnable = new Runnable(){

                public void run() {
                    PlayFrame.this.play(serviceItemArray, serviceItem);
                }
            };
            SwingUtilities.invokeLater(runnable);
        } else if (object instanceof Source && remoteEvent.getID() == 1L) {
            System.out.println("Source stopped event");
        }
    }

    private void enableVolumeControl(VolumeControl volumeControl, JSlider jSlider) {
        int n = 0;
        int n2 = 0;
        try {
            n = volumeControl.getMaxVolume();
            if (n <= 0) {
                return;
            }
            n2 = volumeControl.getVolume();
            System.out.println("Current vol: " + n2);
            if (n2 < 0 || n2 > n) {
                return;
            }
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
            return;
        }
        jSlider.setMinimum(0);
        jSlider.setMaximum(n);
        jSlider.setValue(n2);
        jSlider.setEnabled(true);
    }
}

