/*
 * Decompiled with CFR 0.152.
 */
package zeroconf;

import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import zeroconf.HttpServer;

public class HttpServer
extends Thread {
    private static Logger logger = Logger.getLogger("zeroconf.HttpServer");
    private ServerSocket server;
    private String hostAddr;
    private String dir;
    private int port = 0;
    private HashMap map;
    private boolean verbose;
    private FilePermission perm;

    public HttpServer(String string, int n, String string2) throws IOException {
        this.init(string, n, string2, null);
    }

    public HttpServer(Configuration configuration) throws IOException {
        this.init(null, 0, null, configuration);
    }

    private void init(String string, int n, String string2, Configuration configuration) throws IOException {
        this.hostAddr = string;
        this.port = n;
        if (!string2.endsWith(File.separator)) {
            string2 = string2 + File.separatorChar;
        }
        this.dir = string2;
        this.getConfig(configuration);
        this.server = new ServerSocket(n);
        n = this.server.getLocalPort();
        System.setProperty("java.rmi.server.codebase", "http://" + string + ":" + n + "/" + string2);
        this.perm = new FilePermission(string2 + '-', "read");
        this.map = new HashMap();
        File file = new File(string2);
        String[] stringArray = file.list();
        if (stringArray == null) {
            return;
        }
        URL uRL = file.toURL();
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            if (!string3.endsWith(".jar") && !string3.endsWith(".zip")) continue;
            ArrayList arrayList = new ArrayList(1);
            this.addJar(string3, arrayList, uRL);
            this.map.put(string3.substring(0, string3.length() - 4), arrayList.toArray(new JarFile[arrayList.size()]));
        }
    }

    private void getConfig(Configuration configuration) {
        String string = null;
        if (configuration != null) {
            try {
                Integer n = (Integer)configuration.getEntry("zeroconf.http", "port", Integer.class, (Object)new Integer(this.port));
                this.port = n;
                this.dir = (String)configuration.getEntry("zeroconf.http", "basedir", String.class, (Object)this.dir);
                string = (String)configuration.getEntry("zeroconf.http", "address", String.class, null);
            }
            catch (ConfigurationException configurationException) {
                logger.log(Level.SEVERE, configurationException.toString());
            }
        }
        if (string == null) {
            string = this.getLocalAddress();
        }
    }

    private String getLocalAddress() {
        String string = null;
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            logger.log(Level.SEVERE, unknownHostException.toString());
        }
        return string;
    }

    private void addJar(String string, ArrayList arrayList, URL uRL) throws IOException {
        uRL = new URL(uRL, string);
        string = uRL.getFile().replace('/', File.separatorChar);
        int n = arrayList.size();
        while (--n >= 0) {
            if (!string.equals(((JarFile)arrayList.get(n)).getName())) continue;
            return;
        }
        logger.config(string);
        JarFile jarFile = new JarFile(string);
        arrayList.add(jarFile);
        Manifest manifest = jarFile.getManifest();
        if (manifest == null) {
            return;
        }
        Attributes attributes = manifest.getMainAttributes();
        if (attributes == null) {
            return;
        }
        String string2 = attributes.getValue(Attributes.Name.CLASS_PATH);
        if (string2 == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        while (stringTokenizer.hasMoreTokens()) {
            this.addJar(stringTokenizer.nextToken(), arrayList, uRL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        logger.log(Level.INFO, "HTTP Server started [{0}, port {1}]", new Object[]{this.dir, Integer.toString(this.getPort())});
        try {
            while (true) {
                new Task(this, this.server.accept()).start();
            }
        }
        catch (IOException iOException) {
            HttpServer httpServer = this;
            synchronized (httpServer) {
                if (!this.server.isClosed()) {
                    logger.log(Level.SEVERE, "accepting connection", iOException);
                }
                this.terminate();
            }
            return;
        }
    }

    public synchronized void terminate() {
        try {
            this.server.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        logger.log(Level.INFO, "HTTPServer terminated [port {0}]", Integer.toString(this.getPort()));
    }

    public int getPort() {
        return this.server.getLocalPort();
    }

    static /* synthetic */ HashMap access$000(HttpServer httpServer) {
        return httpServer.map;
    }

    static /* synthetic */ String access$100(HttpServer httpServer) {
        return httpServer.dir;
    }

    static /* synthetic */ FilePermission access$200(HttpServer httpServer) {
        return httpServer.perm;
    }

    static /* synthetic */ Logger access$300() {
        return logger;
    }
}

