/*
 * Decompiled with CFR 0.152.
 */
package audio.pull;

import audio.common.AlreadyRecordingException;
import audio.common.IncompatableSourceException;
import audio.common.MimeType;
import audio.common.NoSuchSourceException;
import audio.common.Sink;
import audio.common.Source;
import audio.common.TooManySourcesException;
import audio.pull.ContentSink;
import audio.transport.HttpSinkImpl;
import audio.transport.HttpSource;
import audio.transport.TcpSinkImpl;
import audio.transport.TcpSource;
import audio.transport.TransportSink;
import java.io.InputStream;
import java.rmi.MarshalledObject;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import net.jini.core.event.EventRegistration;
import net.jini.core.event.RemoteEvent;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.event.UnknownEventException;

public class SinkImpl
implements Sink,
Remote {
    private Source source;
    private boolean stopped;
    private CopyIO copyIO;
    private Hashtable listeners = new Hashtable();
    private int seqNum = 0;
    private Remote proxy;
    private MimeType contentType = null;
    private InputStream in = null;

    public void setProxy(Remote remote) {
        this.proxy = remote;
    }

    public void record() throws RemoteException, AlreadyRecordingException {
        if (this.copyIO != null && !this.stopped) {
            throw new AlreadyRecordingException();
        }
        if (this.source == null) {
            return;
        }
        this.stopped = false;
        if (this.in == null) {
            System.out.println("Couldn't get input stream");
            this.stopped = true;
            return;
        }
        this.copyIO = new CopyIO(this, this.in, this.source);
        this.copyIO.start();
        System.out.println("Play returning");
    }

    public void stop() throws RemoteException {
        this.stopped = true;
        if (this.copyIO != null) {
            this.copyIO.stopRecord();
        }
    }

    public void contentStopped() {
        this.copyIO = null;
        this.fireNotify(1);
        System.out.println("Stopped");
    }

    public void addSource(Source source) throws IncompatableSourceException, TooManySourcesException {
        TransportSink transportSink = null;
        this.source = source;
        if (source instanceof HttpSource) {
            transportSink = new HttpSinkImpl((HttpSource)source);
            this.in = transportSink.getInputStream();
        } else if (source instanceof TcpSource) {
            System.out.println("Setting up Tcp sink");
            transportSink = new TcpSinkImpl((TcpSource)source);
            this.in = transportSink.getInputStream();
            System.out.println("Got tcp source input stream " + this.in);
        } else {
            throw new IncompatableSourceException();
        }
    }

    public void removeSource(Source source) throws RemoteException, NoSuchSourceException {
        if (this.source != source) {
            throw new NoSuchSourceException();
        }
        this.source = null;
    }

    public EventRegistration addSinkListener(RemoteEventListener remoteEventListener, MarshalledObject marshalledObject) {
        System.out.println("Adding listener: " + remoteEventListener);
        this.listeners.put(remoteEventListener, marshalledObject);
        return new EventRegistration(0L, (Object)this.proxy, null, 0L);
    }

    public void removeSinkListener(RemoteEventListener remoteEventListener) {
        this.listeners.remove(remoteEventListener);
    }

    public void fireNotify(int n) {
        Enumeration enumeration = this.listeners.keys();
        System.out.println("Fire notify");
        while (enumeration.hasMoreElements()) {
            RemoteEventListener remoteEventListener = (RemoteEventListener)enumeration.nextElement();
            MarshalledObject marshalledObject = (MarshalledObject)this.listeners.get(remoteEventListener);
            RemoteEvent remoteEvent = new RemoteEvent((Object)this.proxy, (long)n, (long)this.seqNum++, marshalledObject);
            System.out.println("Updating listener " + remoteEventListener);
            try {
                remoteEventListener.notify(remoteEvent);
            }
            catch (UnknownEventException unknownEventException) {
            }
            catch (RemoteException remoteException) {}
        }
    }

    class CopyIO
    extends Thread {
        private SinkImpl sink;
        private ContentSink contentSink;

        CopyIO(SinkImpl sinkImpl2, InputStream inputStream, Source source) {
            this.contentSink = ContentSink.createSink(sinkImpl2, inputStream, source);
            this.sink = sinkImpl2;
        }

        public void stopRecord() {
            if (this.contentSink != null) {
                this.contentSink.stop();
            }
        }

        public void run() {
            this.contentSink.record();
        }
    }
}

