/*
 * Decompiled with CFR 0.152.
 */
package client;

import common.Distance;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.util.Vector;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceMatches;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.core.lookup.ServiceTemplate;
import net.jini.discovery.DiscoveryEvent;
import net.jini.discovery.DiscoveryListener;
import net.jini.discovery.LookupDiscovery;
import net.jini.lookup.entry.Location;

public class TestPrinterDistance
implements DiscoveryListener {
    protected Distance distance = null;
    protected Object distanceLock = new Object();
    protected Vector printers = new Vector();

    public static void main(String[] stringArray) {
        new TestPrinterDistance();
        try {
            Thread.currentThread();
            Thread.sleep(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public TestPrinterDistance() {
        System.setSecurityManager(new RMISecurityManager());
        LookupDiscovery lookupDiscovery = null;
        try {
            lookupDiscovery = new LookupDiscovery(LookupDiscovery.ALL_GROUPS);
        }
        catch (Exception exception) {
            System.err.println(exception.toString());
            System.exit(1);
        }
        lookupDiscovery.addDiscoveryListener((DiscoveryListener)this);
    }

    public void discovered(DiscoveryEvent discoveryEvent) {
        ServiceRegistrar[] serviceRegistrarArray = discoveryEvent.getRegistrars();
        for (int i = 0; i < serviceRegistrarArray.length; ++i) {
            System.out.println("Service found");
            ServiceRegistrar serviceRegistrar = serviceRegistrarArray[i];
            new LookupThread(serviceRegistrar).start();
        }
    }

    public void discarded(DiscoveryEvent discoveryEvent) {
    }

    class LookupThread
    extends Thread {
        ServiceRegistrar registrar;

        LookupThread(ServiceRegistrar serviceRegistrar) {
            this.registrar = serviceRegistrar;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object;
            Object object2 = TestPrinterDistance.this.distanceLock;
            synchronized (object2) {
                if (TestPrinterDistance.this.distance == null) {
                    this.lookupDistance();
                }
                if (TestPrinterDistance.this.distance != null) {
                    Vector vector = TestPrinterDistance.this.printers;
                    synchronized (vector) {
                        for (int i = 0; i < TestPrinterDistance.this.printers.size(); ++i) {
                            object = (ServiceItem)TestPrinterDistance.this.printers.elementAt(i);
                            this.reportDistance((ServiceItem)object);
                        }
                    }
                }
            }
            object2 = this.lookupPrinters();
            for (int i = 0; i < ((ServiceMatches)object2).items.length; ++i) {
                if (((ServiceMatches)object2).items[i] == null) continue;
                Object object3 = TestPrinterDistance.this.distanceLock;
                synchronized (object3) {
                    if (TestPrinterDistance.this.distance != null) {
                        this.reportDistance(((ServiceMatches)object2).items[i]);
                    } else {
                        object = TestPrinterDistance.this.printers;
                        synchronized (object) {
                            TestPrinterDistance.this.printers.addElement(((ServiceMatches)object2).items[i]);
                        }
                    }
                    continue;
                }
            }
        }

        void lookupDistance() {
            Class[] classArray = new Class[]{Distance.class};
            ServiceTemplate serviceTemplate = new ServiceTemplate(null, classArray, null);
            try {
                TestPrinterDistance.this.distance = (Distance)this.registrar.lookup(serviceTemplate);
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
            }
        }

        ServiceMatches lookupPrinters() {
            Entry[] entryArray = new Entry[]{new Location(null, null, null)};
            Class[] classArray = new Class[1];
            try {
                classArray[0] = Class.forName("common.Printer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println("Class not found");
                System.exit(1);
            }
            ServiceTemplate serviceTemplate = new ServiceTemplate(null, classArray, entryArray);
            ServiceMatches serviceMatches = null;
            try {
                serviceMatches = this.registrar.lookup(serviceTemplate, 10);
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
            }
            return serviceMatches;
        }

        void reportDistance(ServiceItem serviceItem) {
            Location location = this.getMyLocation();
            Location location2 = this.getPrinterLocation(serviceItem);
            if (location2 != null) {
                int n = TestPrinterDistance.this.distance.getDistance(location, location2);
                System.out.println("Found a printer at " + n + " units of length away");
            }
        }

        Location getMyLocation() {
            return new Location("1", "1", "Building 1");
        }

        Location getPrinterLocation(ServiceItem serviceItem) {
            Entry[] entryArray = serviceItem.attributeSets;
            for (int i = 0; i < entryArray.length; ++i) {
                if (!(entryArray[i] instanceof Location)) continue;
                return (Location)entryArray[i];
            }
            return null;
        }
    }
}

