/*
 * Decompiled with CFR 0.152.
 */
package audio.httpsource;

import audio.common.Directory;
import audio.http.HttpMP3SourceImpl;
import audio.http.HttpOggSourceImpl;
import audio.http.HttpSourceImpl;
import audio.http.HttpWAVSourceImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.rmi.RMISecurityManager;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.ExportException;
import java.util.Vector;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationProvider;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceID;
import net.jini.discovery.DiscoveryManagement;
import net.jini.discovery.LookupDiscovery;
import net.jini.discovery.LookupDiscoveryManager;
import net.jini.export.Exporter;
import net.jini.id.Uuid;
import net.jini.id.UuidFactory;
import net.jini.lease.LeaseRenewalManager;
import net.jini.lookup.JoinManager;
import net.jini.lookup.entry.Name;

public class DirectoryServer
implements Directory {
    private ServiceID serviceID = null;
    private ServiceID[] serviceIDs;
    protected Remote proxy;
    protected HttpSourceImpl impl;
    private Entry[] dirEntries;
    private String cdInfo;
    private URL url = null;
    private Exporter exporter = null;
    private String cdIndexDiscID;
    private String cddbDiscID;
    private URL[] trackURLs;
    private String[] trackNames;
    private Configuration config;
    private File serviceIDFile;
    private JoinManager[] joinMgrs;
    private JoinManager dirJoinMgr;
    private LeaseRenewalManager leaseRenewalManager;
    private Vector sources = new Vector();

    public DirectoryServer(String[] configArgs, LeaseRenewalManager leaseRenewalManager) {
        this.leaseRenewalManager = leaseRenewalManager;
        System.out.println("1");
        this.getConfiguration(configArgs);
        System.out.println("2");
        this.cdInfo = this.getCDInfo();
        System.out.println("3");
        this.joinMgrs = new JoinManager[this.trackURLs.length];
        System.out.println("4");
        this.printMem("Making file services");
        System.out.println("5");
        for (int n = 0; n < this.trackURLs.length; ++n) {
            this.printMem("Service " + this.trackURLs[n]);
            this.makeFileService(n, this.trackURLs[n]);
        }
        this.makeDirService();
    }

    public ServiceID[] getServiceIDs() throws RemoteException {
        return this.serviceIDs;
    }

    private void printMem(String arg) {
        Runtime runt = Runtime.getRuntime();
        try {
            System.gc();
            Thread.currentThread();
            Thread.sleep(100L);
            System.runFinalization();
            Thread.currentThread();
            Thread.sleep(100L);
            System.gc();
            Thread.currentThread();
            Thread.sleep(100L);
            System.runFinalization();
            Thread.currentThread();
            Thread.sleep(100L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        long totalMemory = Runtime.getRuntime().totalMemory();
        try {
            System.gc();
            Thread.currentThread();
            Thread.sleep(100L);
            System.runFinalization();
            Thread.currentThread();
            Thread.sleep(100L);
            System.gc();
            Thread.currentThread();
            Thread.sleep(100L);
            System.runFinalization();
            Thread.currentThread();
            Thread.sleep(100L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        long freeMemory = Runtime.getRuntime().freeMemory();
        System.out.println(arg + ": memory used: " + (totalMemory - freeMemory));
    }

    private void getConfiguration(String[] configArgs) {
        Class cls;
        try {
            this.config = ConfigurationProvider.getInstance((String[])configArgs);
            System.out.println("Config is " + this.config);
        }
        catch (Exception e) {
            System.err.println(e.toString());
            e.printStackTrace();
            System.exit(1);
        }
        try {
            cls = Entry[].class;
            System.out.println(cls.toString());
            this.dirEntries = (Entry[])this.config.getEntry("HttpFileSourceServer", "entries", cls);
        }
        catch (Exception e) {
            System.err.println("Config error: " + e.toString());
        }
        try {
            this.cdIndexDiscID = (String)this.config.getEntry("HttpFileSourceServer", "cdIndexDiscID", String.class);
        }
        catch (Exception e) {
            System.err.println("Config error: " + e.toString());
        }
        try {
            this.cddbDiscID = (String)this.config.getEntry("HttpFileSourceServer", "cddbDiscID", String.class, null);
        }
        catch (Exception e) {
            System.err.println("Config error: " + e.toString());
        }
        try {
            cls = URL[].class;
            System.out.println(cls.toString());
            this.trackURLs = (URL[])this.config.getEntry("HttpFileSourceServer", "trackURLs", cls);
        }
        catch (Exception e) {
            System.err.println("Config error: " + e.toString());
        }
        try {
            cls = String[].class;
            System.out.println(cls.toString());
            this.trackNames = (String[])this.config.getEntry("HttpFileSourceServer", "trackNames", cls);
        }
        catch (Exception e) {
            System.err.println("Config error: " + e.toString());
        }
        try {
            this.serviceIDFile = (File)this.config.getEntry("HttpFileSourceServer", "serviceIDFile", File.class);
            this.getOrMakeServiceIDs(this.serviceIDFile);
        }
        catch (Exception e) {
            System.err.println("Config error: " + e.toString());
        }
    }

    private void getOrMakeServiceIDs(File serviceIDFile) {
        this.serviceIDs = new ServiceID[this.trackURLs.length];
        try {
            ObjectInputStream ois = new ObjectInputStream(new FileInputStream(serviceIDFile));
            this.serviceID = (ServiceID)ois.readObject();
            System.out.println("Got dir service id " + this.serviceID);
            for (int n = 0; n < this.trackURLs.length; ++n) {
                this.serviceIDs[n] = (ServiceID)ois.readObject();
                System.out.println("Got service id " + this.serviceIDs[n]);
            }
        }
        catch (Exception e) {
            System.out.println("Couldn't get service IDs - generating new ones");
            try {
                ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(serviceIDFile));
                Uuid uuid = UuidFactory.generate();
                this.serviceID = new ServiceID(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
                oos.writeObject(this.serviceID);
                for (int n = 0; n < this.serviceIDs.length; ++n) {
                    Uuid uuidFile = UuidFactory.generate();
                    ServiceID id = new ServiceID(uuidFile.getMostSignificantBits(), uuidFile.getLeastSignificantBits());
                    oos.writeObject(id);
                    this.serviceIDs[n] = id;
                    System.out.println("Generating service id " + this.serviceIDs[n]);
                }
            }
            catch (Exception e2) {
                System.out.println("Couldn't save ids");
                e2.printStackTrace();
            }
        }
    }

    private void makeDirService() {
        try {
            this.exporter = (Exporter)this.config.getEntry("HttpFileSourceServer", "exporter", Exporter.class);
        }
        catch (Exception e) {
            System.err.println(e.toString());
            e.printStackTrace();
            System.exit(1);
        }
        try {
            System.out.println("Export dir using exporter " + this.exporter);
            this.proxy = this.exporter.export((Remote)this);
        }
        catch (ExportException e) {
            System.err.println(e.toString());
            e.printStackTrace();
            System.exit(1);
        }
        this.dirJoinMgr = this.registerService(this.proxy, this.serviceID, this.dirEntries);
    }

    private void makeFileService(int index, URL url) {
        Exporter exporter;
        block9: {
            exporter = null;
            try {
                exporter = (Exporter)this.config.getEntry("HttpFileSourceServer", "exporter", Exporter.class);
            }
            catch (Exception e) {
                System.err.println(e.toString());
                e.printStackTrace();
                System.exit(1);
            }
            String urlStr = url.toString();
            System.out.println("URL is " + urlStr);
            try {
                if (urlStr.endsWith("wav")) {
                    this.impl = new HttpWAVSourceImpl(url);
                    break block9;
                }
                if (urlStr.endsWith("mp3")) {
                    this.impl = new HttpMP3SourceImpl(url);
                    break block9;
                }
                if (urlStr.endsWith("ogg")) {
                    this.impl = new HttpOggSourceImpl(url);
                    break block9;
                }
                System.out.println("Can't handle presentation type: " + url);
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                return;
            }
        }
        this.sources.add(this.impl);
        try {
            System.out.println("Export file " + url + " using exporter " + exporter);
            this.proxy = exporter.export((Remote)this.impl);
        }
        catch (ExportException e) {
            System.err.println(e.toString());
            e.printStackTrace();
            System.exit(1);
        }
        String trackInfo = this.getTrackInfo(index);
        Entry[] entries = new Entry[]{new Name(trackInfo)};
        this.joinMgrs[index] = this.registerService(this.proxy, this.serviceIDs[index], entries);
    }

    private JoinManager registerService(Remote proxy, ServiceID serviceID, Entry[] entries) {
        JoinManager joinMgr = null;
        try {
            LookupDiscoveryManager mgr = new LookupDiscoveryManager(LookupDiscovery.ALL_GROUPS, null, null);
            System.out.println("Registering with id " + serviceID);
            joinMgr = new JoinManager((Object)proxy, entries, serviceID, (DiscoveryManagement)mgr, this.leaseRenewalManager);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        return joinMgr;
    }

    public String getTrackInfo(int index) {
        if (this.trackNames != null && this.trackNames.length > index && this.trackNames[index] != null) {
            return this.cdInfo + ": " + this.trackNames[index];
        }
        String indexStr = null;
        indexStr = index < 9 ? "0" + (index + 1) : "" + (index + 1);
        return this.cdInfo + ": Track " + indexStr;
    }

    public String getCDInfo() {
        if (this.dirEntries == null) {
            return "";
        }
        for (int n = 0; n < this.dirEntries.length; ++n) {
            if (!(this.dirEntries[n] instanceof Name)) continue;
            return ((Name)this.dirEntries[n]).name;
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] argv) {
        Object keepAlive;
        LeaseRenewalManager leaseRenewalManager = new LeaseRenewalManager();
        System.setSecurityManager(new RMISecurityManager());
        DirectoryServer ds = new DirectoryServer(argv, leaseRenewalManager);
        Object object = keepAlive = new Object();
        synchronized (object) {
            try {
                keepAlive.wait();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
    }
}

