/*
 * Decompiled with CFR 0.152.
 */
package audio.client;

import audio.client.ClientFrame;
import audio.client.PlayFrame;
import audio.common.Directory;
import audio.common.Sink;
import audio.common.Source;
import java.rmi.RMISecurityManager;
import java.rmi.Remote;
import java.rmi.RemoteException;
import javax.swing.tree.DefaultMutableTreeNode;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationProvider;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceTemplate;
import net.jini.discovery.DiscoveryManagement;
import net.jini.discovery.LookupDiscovery;
import net.jini.discovery.LookupDiscoveryManager;
import net.jini.export.Exporter;
import net.jini.lease.LeaseRenewalManager;
import net.jini.lookup.LookupCache;
import net.jini.lookup.ServiceDiscoveryEvent;
import net.jini.lookup.ServiceDiscoveryListener;
import net.jini.lookup.ServiceDiscoveryManager;

public class GUIClient
implements ServiceDiscoveryListener {
    private static final long WAITFOR = 100000L;
    private ClientFrame clientFrame;
    private LookupCache cache;
    private ServiceDiscoveryManager clientMgr;
    private static String CONFIG_FILE = "resources/audio/jeri/http_sink_server.config";

    public static void main(String[] argv) {
        ClientFrame cf = new ClientFrame();
        GUIClient client = new GUIClient(cf);
        cf.setClient(client);
        cf.setSize(600, 600);
        cf.setVisible(true);
    }

    public GUIClient(ClientFrame cf) {
        this.clientFrame = cf;
        System.setSecurityManager(new RMISecurityManager());
        try {
            LookupDiscoveryManager mgr = new LookupDiscoveryManager(LookupDiscovery.ALL_GROUPS, null, null);
            this.clientMgr = new ServiceDiscoveryManager((DiscoveryManagement)mgr, new LeaseRenewalManager());
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        ServiceTemplate template = new ServiceTemplate(null, null, null);
        try {
            this.cache = this.clientMgr.createLookupCache(template, null, (ServiceDiscoveryListener)this);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public void serviceAdded(ServiceDiscoveryEvent evt) {
        ServiceItem postItem = evt.getPostEventServiceItem();
        System.out.println("Service appeared: " + postItem.service.getClass().toString());
        if (postItem.service instanceof Directory) {
            System.out.println("  is dir");
            this.addDirectory(postItem);
        }
        if (postItem.service instanceof Sink) {
            System.out.println("  is sink");
            this.clientFrame.addSink(postItem);
        }
        if (postItem.service instanceof Source) {
            System.out.println("  is source");
            this.clientFrame.addSource(postItem);
        }
    }

    public void serviceChanged(ServiceDiscoveryEvent evt) {
        ServiceItem preItem = evt.getPostEventServiceItem();
        ServiceItem postItem = evt.getPreEventServiceItem();
        System.out.println("Service changed: " + postItem.service.getClass().toString());
    }

    public void serviceRemoved(ServiceDiscoveryEvent evt) {
        ServiceItem preItem = evt.getPreEventServiceItem();
        System.out.println("Service disappeared: " + preItem.service.getClass().toString());
        if (preItem.service instanceof Directory) {
            System.out.println("  was dir");
            this.clientFrame.removeDirectory(preItem);
        }
        if (preItem.service instanceof Sink) {
            System.out.println("  was sink");
            this.clientFrame.removeSink(preItem);
        }
        if (preItem.service instanceof Source) {
            System.out.println("  was source");
            this.clientFrame.removeSource(preItem);
        }
    }

    private void addDirectory(ServiceItem item) {
        DefaultMutableTreeNode node = this.clientFrame.addDirectory(item);
        ServiceID[] ids = null;
        try {
            ids = ((Directory)item.service).getServiceIDs();
        }
        catch (RemoteException e) {
            System.err.println(e.toString());
            return;
        }
        for (int n = 0; n < ids.length; ++n) {
            ServiceID id = ids[n];
            ServiceTemplate tmpl = new ServiceTemplate(id, null, null);
            ServiceItem dirItem = null;
            try {
                dirItem = this.clientMgr.lookup(tmpl, null, 100000L);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (dirItem != null) {
                this.clientFrame.addDirectoryElement(node, dirItem);
                continue;
            }
            System.out.println("Adding to dir " + item.serviceID + ": couldn't find dir element " + id);
        }
    }

    public Remote export(PlayFrame cf) {
        String[] configArgs = new String[]{CONFIG_FILE};
        try {
            Configuration config = ConfigurationProvider.getInstance((String[])configArgs);
            Exporter exporter = (Exporter)config.getEntry("HttpSinkServer", "exporter", Exporter.class);
            Remote proxy = exporter.export((Remote)((Object)cf));
            return proxy;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

