/*
 * Decompiled with CFR 0.152.
 */
package audio.common;

import java.io.Serializable;

public class MimeType
implements Serializable {
    protected String contentType;
    protected String subtype;
    public static final MimeType WAV = new MimeType("audio/wav");
    public static final MimeType MPEG = new MimeType("audio/mpeg");
    public static final MimeType OGG_VORBIS = new MimeType("application/x-ogg");

    public MimeType(String type) {
        int slash = type.indexOf(47);
        this.contentType = type.substring(0, slash);
        this.subtype = type.substring(slash + 1, type.length());
    }

    public MimeType(String contentType, String subtype) {
        this.contentType = contentType;
        this.subtype = subtype;
    }

    public String toString() {
        return this.contentType + "/" + this.subtype;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MimeType)) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }
}

