/*
 * Decompiled with CFR 0.152.
 */
package audio.aumix;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class Aumix {
    private static int volume;

    public static void setOutputVolume(int vol) {
        try {
            Runtime.getRuntime().exec("aumix -w " + volume + "," + volume);
            volume = vol;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void setInputVolume(int vol) {
        try {
            Runtime.getRuntime().exec("aumix -i " + volume + "," + volume);
            volume = vol;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static int getVolume() {
        return volume;
    }

    public static int getMaxVolume() {
        return 100;
    }

    private static int getVolumeFromDevice() {
        Process aumixProc = null;
        try {
            aumixProc = Runtime.getRuntime().exec("aumix -iq");
        }
        catch (IOException e) {
            System.err.println(e);
            return 0;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(aumixProc.getInputStream()));
        String response = null;
        try {
            response = reader.readLine();
        }
        catch (IOException e) {
            System.err.println(e);
            return 0;
        }
        response = response.substring(5);
        String[] vols = response.split(",");
        int left = 0;
        int right = 0;
        try {
            right = Integer.parseInt(vols[0].trim());
            left = Integer.parseInt(vols[1].trim());
        }
        catch (NumberFormatException e) {
            System.err.println("Number error in '" + vols[0] + "' or '" + vols[1] + "'");
            return 0;
        }
        return (right + left) / 2;
    }
}

