/*
 * Decompiled with CFR 0.152.
 */
package client;

import common.FileClassifier;
import common.MIMEType;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.core.lookup.ServiceTemplate;
import net.jini.discovery.DiscoveryEvent;
import net.jini.discovery.DiscoveryListener;
import net.jini.discovery.LookupDiscovery;

public class TestFileClassifier
implements DiscoveryListener {
    public static void main(String[] stringArray) {
        new TestFileClassifier();
        try {
            Thread.currentThread();
            Thread.sleep(100000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public TestFileClassifier() {
        System.setSecurityManager(new RMISecurityManager());
        LookupDiscovery lookupDiscovery = null;
        try {
            lookupDiscovery = new LookupDiscovery(LookupDiscovery.ALL_GROUPS);
        }
        catch (Exception exception) {
            System.err.println(exception.toString());
            System.exit(1);
        }
        lookupDiscovery.addDiscoveryListener((DiscoveryListener)this);
    }

    public void discovered(DiscoveryEvent discoveryEvent) {
        ServiceRegistrar[] serviceRegistrarArray = discoveryEvent.getRegistrars();
        Class[] classArray = new Class[]{FileClassifier.class};
        FileClassifier fileClassifier = null;
        ServiceTemplate serviceTemplate = new ServiceTemplate(null, classArray, null);
        for (int i = 0; i < serviceRegistrarArray.length; ++i) {
            System.out.println("Lookup service found");
            ServiceRegistrar serviceRegistrar = serviceRegistrarArray[i];
            try {
                fileClassifier = (FileClassifier)serviceRegistrar.lookup(serviceTemplate);
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
                continue;
            }
            if (fileClassifier == null) {
                System.out.println("Classifier null");
                continue;
            }
            try {
                String string = "file1.txt";
                MIMEType mIMEType = fileClassifier.getMIMEType(string);
                this.printType(string, mIMEType);
                string = "file2.rtf";
                mIMEType = fileClassifier.getMIMEType(string);
                this.printType(string, mIMEType);
                string = "file3.abc";
                mIMEType = fileClassifier.getMIMEType(string);
                this.printType(string, mIMEType);
            }
            catch (RemoteException remoteException) {
                System.err.println(remoteException.toString());
                continue;
            }
            System.exit(0);
        }
    }

    private void printType(String string, MIMEType mIMEType) {
        System.out.print("Type of " + string + " is ");
        if (mIMEType == null) {
            System.out.println("null");
        } else {
            System.out.println(mIMEType.toString());
        }
    }

    public void discarded(DiscoveryEvent discoveryEvent) {
    }
}

