/*
 * Decompiled with CFR 0.152.
 */
package audio.common;

import audio.common.CDTrack;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceItem;
import net.jini.lookup.entry.Name;

public class ComparableServiceItem
extends ServiceItem
implements Comparable {
    private String compareStr;

    public ComparableServiceItem(ServiceItem item) {
        super(item.serviceID, item.service, item.attributeSets);
        if (this.attributeSets != null) {
            for (int n = 0; n < this.attributeSets.length; ++n) {
                if (this.attributeSets[n] instanceof CDTrack) {
                    CDTrack track = (CDTrack)this.attributeSets[n];
                    String trackPrefix = track.trackNumber <= 9 ? "0" : "";
                    this.compareStr = track.artist + " / " + track.title + " " + trackPrefix + track.trackNumber;
                    break;
                }
                if (!(this.attributeSets[0] instanceof Name)) continue;
                this.compareStr = ((Name)this.attributeSets[0]).name;
                break;
            }
        }
    }

    public int compareTo(Object obj) {
        ComparableServiceItem item = (ComparableServiceItem)obj;
        if (this.serviceID.equals((Object)item.serviceID)) {
            System.out.println("Equal serviceID");
            return 0;
        }
        if (this.compareStr != null && item.attributeSets != null && item.attributeSets.length != 0 && item.attributeSets[0] instanceof Name) {
            String name = ((Name)item.attributeSets[0]).name;
            return this.compareStr.compareTo(name);
        }
        System.out.println("Comparing on serviceID");
        if (this.serviceID.getMostSignificantBits() >= item.serviceID.getMostSignificantBits()) {
            return 1;
        }
        return -1;
    }

    public boolean equals(Object item) {
        System.out.println("Testing equals");
        return this.compareTo(item) == 0;
    }

    public String toString() {
        Entry[] entries = this.attributeSets;
        String ret = this.service.toString();
        if (entries != null) {
            for (int n = 0; n < entries.length; ++n) {
                if (!(entries[n] instanceof Name)) continue;
                ret = ((Name)entries[n]).name;
                break;
            }
        }
        return ret;
    }
}

