/*
 * Decompiled with CFR 0.152.
 */
package audio.client;

import audio.common.CDTrack;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceItem;
import net.jini.lookup.entry.Name;

public class LabelCellRenderer
extends JLabel
implements ListCellRenderer,
TreeCellRenderer {
    public LabelCellRenderer() {
        this.setOpaque(true);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        ServiceItem item = (ServiceItem)value;
        Entry[] entries = item.attributeSets;
        this.setText(item.service.toString());
        if (entries != null) {
            for (int n = 0; n < entries.length; ++n) {
                if (entries[n] instanceof CDTrack) {
                    CDTrack track = (CDTrack)entries[n];
                    this.setText(track.artist + " / " + track.title + ": " + track.trackTitle);
                    break;
                }
                if (!(entries[n] instanceof Name)) continue;
                this.setText(((Name)entries[n]).name);
                break;
            }
        }
        this.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
        this.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
        return this;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean isExpanded, boolean isLeaf, int row, boolean cellHasFocus) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        Object nodeObj = node.getUserObject();
        if (isSelected) {
            this.setBackground(UIManager.getColor("Tree.selectionBackground"));
            this.setForeground(UIManager.getColor("Tree.selectionForeground"));
        } else {
            this.setBackground(UIManager.getColor("Tree.textBackground"));
            this.setForeground(UIManager.getColor("Tree.selectionForeground"));
        }
        if (nodeObj instanceof String) {
            this.setText((String)nodeObj);
            return this;
        }
        if (nodeObj instanceof ServiceItem) {
            ServiceItem item = (ServiceItem)node.getUserObject();
            this.setText(item.toString());
            return this;
        }
        return null;
    }
}

