/*
 * Decompiled with CFR 0.152.
 */
package config;

import complete.FileClassifierImpl;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.ConfigurationProvider;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.core.lookup.ServiceRegistration;
import net.jini.discovery.DiscoveryEvent;
import net.jini.discovery.DiscoveryListener;
import net.jini.discovery.LookupDiscovery;
import net.jini.lease.LeaseListener;
import net.jini.lease.LeaseRenewalEvent;
import net.jini.lease.LeaseRenewalManager;

public class FileClassifierServerIDConfig
implements DiscoveryListener,
LeaseListener {
    protected LeaseRenewalManager leaseManager = new LeaseRenewalManager();
    protected ServiceID serviceID = null;
    protected FileClassifierImpl impl = new FileClassifierImpl();
    protected File serviceIdFile;
    static /* synthetic */ Class class$java$io$File;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        Object object;
        FileClassifierServerIDConfig fileClassifierServerIDConfig = new FileClassifierServerIDConfig(stringArray);
        Object object2 = object = new Object();
        synchronized (object2) {
            try {
                object.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public FileClassifierServerIDConfig(String[] stringArray) {
        if (stringArray.length == 0) {
            System.err.println("No configuration specified");
            System.exit(1);
        }
        String[] stringArray2 = new String[]{stringArray[0]};
        Configuration configuration = null;
        try {
            configuration = ConfigurationProvider.getInstance((String[])stringArray2);
            this.serviceIdFile = (File)configuration.getEntry("ServiceIdDemo", "serviceIdFile", class$java$io$File == null ? (class$java$io$File = FileClassifierServerIDConfig.class$("java.io.File")) : class$java$io$File);
        }
        catch (ConfigurationException configurationException) {
            System.err.println("Configuration error: " + configurationException.toString());
            System.exit(1);
        }
        DataInputStream dataInputStream = null;
        try {
            dataInputStream = new DataInputStream(new FileInputStream(this.serviceIdFile));
            this.serviceID = new ServiceID((DataInput)dataInputStream);
            System.out.println("Found service ID in file " + this.serviceIdFile);
            dataInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.setSecurityManager(new RMISecurityManager());
        LookupDiscovery lookupDiscovery = null;
        try {
            lookupDiscovery = new LookupDiscovery(LookupDiscovery.ALL_GROUPS);
        }
        catch (Exception exception) {
            System.err.println("Discovery failed " + exception.toString());
            System.exit(1);
        }
        lookupDiscovery.addDiscoveryListener((DiscoveryListener)this);
    }

    public void discovered(DiscoveryEvent discoveryEvent) {
        ServiceRegistrar[] serviceRegistrarArray = discoveryEvent.getRegistrars();
        for (int i = 0; i < serviceRegistrarArray.length; ++i) {
            ServiceRegistrar serviceRegistrar = serviceRegistrarArray[i];
            ServiceItem serviceItem = new ServiceItem(this.serviceID, (Object)this.impl, null);
            ServiceRegistration serviceRegistration = null;
            try {
                serviceRegistration = serviceRegistrar.register(serviceItem, Long.MAX_VALUE);
            }
            catch (RemoteException remoteException) {
                System.err.println("Register exception: " + remoteException.toString());
                continue;
            }
            System.out.println("Service registered with id " + serviceRegistration.getServiceID());
            this.leaseManager.renewUntil(serviceRegistration.getLease(), Long.MAX_VALUE, (LeaseListener)this);
            if (this.serviceID != null) continue;
            System.out.println("Getting service ID from lookup service");
            this.serviceID = serviceRegistration.getServiceID();
            DataOutputStream dataOutputStream = null;
            try {
                dataOutputStream = new DataOutputStream(new FileOutputStream(this.serviceIdFile));
                this.serviceID.writeBytes((DataOutput)dataOutputStream);
                dataOutputStream.flush();
                dataOutputStream.close();
                System.out.println("Service id saved in " + this.serviceIdFile);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void discarded(DiscoveryEvent discoveryEvent) {
    }

    public void notify(LeaseRenewalEvent leaseRenewalEvent) {
        System.out.println("Lease expired " + leaseRenewalEvent.toString());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

