/*
 * Decompiled with CFR 0.152.
 */
package foolandlord;

import com.sun.jini.landlord.FixedLeasePeriodPolicy;
import com.sun.jini.landlord.Landlord;
import com.sun.jini.landlord.LandlordLease;
import com.sun.jini.landlord.LandlordUtil;
import com.sun.jini.landlord.LeaseFactory;
import com.sun.jini.landlord.LeasePeriodPolicy;
import com.sun.jini.landlord.LeasedResource;
import com.sun.jini.landlord.LocalLandlord;
import foolandlord.Foo;
import foolandlord.FooLeasedResource;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import net.jini.core.lease.Lease;
import net.jini.core.lease.LeaseDeniedException;
import net.jini.core.lease.UnknownLeaseException;
import net.jini.id.Uuid;
import net.jini.id.UuidFactory;
import net.jini.jeri.BasicILFactory;
import net.jini.jeri.BasicJeriExporter;
import net.jini.jeri.InvocationLayerFactory;
import net.jini.jeri.ServerEndpoint;
import net.jini.jeri.tcp.TcpServerEndpoint;

public class FooLandlord
implements Landlord,
LocalLandlord {
    private static final long MAX_LEASE = Long.MAX_VALUE;
    private static final long DEFAULT_LEASE = 300000L;
    private Map leasedResourceMap = new HashMap();
    private LeasePeriodPolicy policy = new FixedLeasePeriodPolicy(Long.MAX_VALUE, 300000L);
    private Uuid myUuid = UuidFactory.generate();
    private LeaseFactory factory;

    public FooLandlord() throws RemoteException {
        BasicJeriExporter basicJeriExporter = new BasicJeriExporter((ServerEndpoint)TcpServerEndpoint.getInstance((int)0), (InvocationLayerFactory)new BasicILFactory());
        Landlord landlord = (Landlord)basicJeriExporter.export((Remote)((Object)this));
        this.factory = new LeaseFactory(landlord, this.myUuid);
    }

    public void cancel(Uuid uuid) throws UnknownLeaseException {
        if (this.leasedResourceMap.remove(uuid) == null) {
            throw new UnknownLeaseException();
        }
    }

    public Map cancelAll(Uuid[] uuidArray) {
        return LandlordUtil.cancelAll((LocalLandlord)this, (Uuid[])uuidArray);
    }

    public long renew(Uuid uuid, long l) throws LeaseDeniedException, UnknownLeaseException {
        LeasedResource leasedResource = (LeasedResource)this.leasedResourceMap.get(uuid);
        LeasePeriodPolicy.Result result = null;
        if (leasedResource == null) {
            throw new UnknownLeaseException();
        }
        result = this.policy.renew(leasedResource, l);
        return result.duration;
    }

    public Landlord.RenewResults renewAll(Uuid[] uuidArray, long[] lArray) {
        return LandlordUtil.renewAll((LocalLandlord)this, (Uuid[])uuidArray, (long[])lArray);
    }

    public LeasePeriodPolicy.Result grant(LeasedResource leasedResource, long l) throws LeaseDeniedException {
        Uuid uuid = leasedResource.getCookie();
        try {
            this.leasedResourceMap.put(uuid, leasedResource);
        }
        catch (Exception exception) {
            throw new LeaseDeniedException(exception.toString());
        }
        return this.policy.grant(leasedResource, l);
    }

    public Lease newFooLease(Foo foo, long l) throws LeaseDeniedException {
        FooLeasedResource fooLeasedResource = new FooLeasedResource(foo);
        Uuid uuid = fooLeasedResource.getCookie();
        LeasePeriodPolicy.Result result = this.grant(fooLeasedResource, l);
        long l2 = result.expiration;
        fooLeasedResource.setExpiration(l2);
        LandlordLease landlordLease = this.factory.newLease(uuid, l2);
        return landlordLease;
    }

    public static void main(String[] stringArray) throws RemoteException, LeaseDeniedException, UnknownLeaseException {
        long l = 2000L;
        FooLandlord fooLandlord = new FooLandlord();
        Lease lease = fooLandlord.newFooLease(new Foo(), l);
        long l2 = lease.getExpiration() - System.currentTimeMillis();
        System.out.println("Lease granted for " + l2 + " msecs");
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        lease.renew(5000L);
        l2 = lease.getExpiration() - System.currentTimeMillis();
        System.out.println("Lease renewed for " + l2 + " msecs");
        lease.cancel();
        System.out.println("Lease cancelled");
    }
}

