/*
 * Decompiled with CFR 0.152.
 */
package client;

import common.LeaseFileClassifier;
import common.MIMEType;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import net.jini.core.lease.Lease;
import net.jini.core.lease.LeaseDeniedException;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.core.lookup.ServiceTemplate;
import net.jini.discovery.DiscoveryEvent;
import net.jini.discovery.DiscoveryListener;
import net.jini.discovery.LookupDiscovery;

public class TestFileClassifierLease
implements DiscoveryListener {
    public static void main(String[] stringArray) {
        new TestFileClassifierLease();
        try {
            Thread.currentThread();
            Thread.sleep(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public TestFileClassifierLease() {
        System.setSecurityManager(new RMISecurityManager());
        LookupDiscovery lookupDiscovery = null;
        try {
            lookupDiscovery = new LookupDiscovery(LookupDiscovery.ALL_GROUPS);
        }
        catch (Exception exception) {
            System.err.println(exception.toString());
            System.exit(1);
        }
        lookupDiscovery.addDiscoveryListener((DiscoveryListener)this);
    }

    public void discovered(DiscoveryEvent discoveryEvent) {
        ServiceRegistrar[] serviceRegistrarArray = discoveryEvent.getRegistrars();
        Class[] classArray = new Class[]{LeaseFileClassifier.class};
        LeaseFileClassifier leaseFileClassifier = null;
        ServiceTemplate serviceTemplate = new ServiceTemplate(null, classArray, null);
        for (int i = 0; i < serviceRegistrarArray.length; ++i) {
            System.out.println("Service found");
            ServiceRegistrar serviceRegistrar = serviceRegistrarArray[i];
            try {
                leaseFileClassifier = (LeaseFileClassifier)serviceRegistrar.lookup(serviceTemplate);
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
                System.exit(2);
            }
            if (leaseFileClassifier == null) {
                System.out.println("Classifier null");
                continue;
            }
            try {
                MIMEType mIMEType = leaseFileClassifier.getMIMEType("file1.txt");
                System.out.println("Type is " + mIMEType.toString());
                Lease lease = leaseFileClassifier.addType("ps", new MIMEType("text", "postscript"));
                if (lease != null) {
                    System.out.println("lease for " + (lease.getExpiration() - System.currentTimeMillis()));
                    mIMEType = leaseFileClassifier.getMIMEType("file1.ps");
                    System.out.println("Type is " + mIMEType.toString());
                    continue;
                }
                System.err.println("was null");
                continue;
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
                continue;
            }
            catch (LeaseDeniedException leaseDeniedException) {
                leaseDeniedException.printStackTrace();
            }
        }
    }

    public void discarded(DiscoveryEvent discoveryEvent) {
    }
}

