/*
 * Decompiled with CFR 0.152.
 */
package lease;

import com.sun.jini.landlord.FixedLeasePeriodPolicy;
import com.sun.jini.landlord.Landlord;
import com.sun.jini.landlord.LandlordLease;
import com.sun.jini.landlord.LandlordUtil;
import com.sun.jini.landlord.LeaseFactory;
import com.sun.jini.landlord.LeasePeriodPolicy;
import com.sun.jini.landlord.LeasedResource;
import com.sun.jini.landlord.LocalLandlord;
import common.LeaseFileClassifier;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.HashMap;
import java.util.Map;
import lease.FileClassifierLeasedResource;
import lease.Reaper;
import net.jini.core.lease.Lease;
import net.jini.core.lease.LeaseDeniedException;
import net.jini.core.lease.UnknownLeaseException;
import net.jini.id.Uuid;
import net.jini.id.UuidFactory;
import net.jini.jeri.BasicILFactory;
import net.jini.jeri.BasicJeriExporter;
import net.jini.jeri.InvocationLayerFactory;
import net.jini.jeri.ServerEndpoint;
import net.jini.jeri.tcp.TcpServerEndpoint;

public class FileClassifierLandlord
implements Landlord,
LocalLandlord {
    private static final long MAX_LEASE = Long.MAX_VALUE;
    private static final long DEFAULT_LEASE = 300000L;
    private Map leasedResourceMap = new HashMap();
    private LeasePeriodPolicy policy = new FixedLeasePeriodPolicy(Long.MAX_VALUE, 300000L);
    private Uuid myUuid = UuidFactory.generate();
    private LeaseFactory factory;

    public FileClassifierLandlord() throws RemoteException {
        BasicJeriExporter basicJeriExporter = new BasicJeriExporter((ServerEndpoint)TcpServerEndpoint.getInstance((int)0), (InvocationLayerFactory)new BasicILFactory());
        Landlord landlord = (Landlord)basicJeriExporter.export((Remote)((Object)this));
        this.factory = new LeaseFactory(landlord, this.myUuid);
        new Reaper(this.leasedResourceMap).start();
    }

    public void cancel(Uuid uuid) throws UnknownLeaseException {
        Object v = this.leasedResourceMap.remove(uuid);
        if (v == null) {
            throw new UnknownLeaseException();
        }
        FileClassifierLeasedResource fileClassifierLeasedResource = (FileClassifierLeasedResource)v;
        try {
            fileClassifierLeasedResource.getFileClassifier().removeType(fileClassifierLeasedResource.getSuffix());
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public Map cancelAll(Uuid[] uuidArray) {
        return LandlordUtil.cancelAll((LocalLandlord)this, (Uuid[])uuidArray);
    }

    public long renew(Uuid uuid, long l) throws LeaseDeniedException, UnknownLeaseException {
        LeasedResource leasedResource = (LeasedResource)this.leasedResourceMap.get(uuid);
        LeasePeriodPolicy.Result result = null;
        if (leasedResource == null) {
            throw new UnknownLeaseException();
        }
        result = this.policy.renew(leasedResource, l);
        return result.duration;
    }

    public LeasePeriodPolicy.Result grant(LeasedResource leasedResource, long l) throws LeaseDeniedException {
        Uuid uuid = leasedResource.getCookie();
        try {
            this.leasedResourceMap.put(uuid, leasedResource);
        }
        catch (Exception exception) {
            throw new LeaseDeniedException(exception.toString());
        }
        return this.policy.grant(leasedResource, l);
    }

    public Lease newFileClassifierLease(LeaseFileClassifier leaseFileClassifier, String string, long l) throws LeaseDeniedException {
        System.out.println("getting new resource");
        FileClassifierLeasedResource fileClassifierLeasedResource = new FileClassifierLeasedResource(leaseFileClassifier, string);
        System.out.println("getting cookie");
        Uuid uuid = fileClassifierLeasedResource.getCookie();
        System.out.println("granting period");
        LeasePeriodPolicy.Result result = this.grant(fileClassifierLeasedResource, l);
        long l2 = result.expiration;
        fileClassifierLeasedResource.setExpiration(l2);
        System.out.println("getting new lease");
        LandlordLease landlordLease = this.factory.newLease(uuid, l2);
        System.out.println("got lease" + landlordLease);
        return landlordLease;
    }

    public Landlord.RenewResults renewAll(Uuid[] uuidArray, long[] lArray) {
        return LandlordUtil.renewAll((LocalLandlord)this, (Uuid[])uuidArray, (long[])lArray);
    }
}

