/*
 * Decompiled with CFR 0.152.
 */
package extended;

import extended.ExtendedFileClassifierImpl;
import extended.FileClassifierProxy;
import java.rmi.RMISecurityManager;
import java.rmi.Remote;
import java.rmi.RemoteException;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationProvider;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.core.lookup.ServiceRegistration;
import net.jini.discovery.DiscoveryEvent;
import net.jini.discovery.DiscoveryListener;
import net.jini.discovery.LookupDiscovery;
import net.jini.export.Exporter;
import net.jini.lease.LeaseListener;
import net.jini.lease.LeaseRenewalEvent;
import net.jini.lease.LeaseRenewalManager;

public class FileClassifierServer
implements DiscoveryListener,
LeaseListener {
    protected FileClassifierProxy smartProxy;
    protected Remote rmiProxy;
    protected ExtendedFileClassifierImpl impl;
    protected LeaseRenewalManager leaseManager = new LeaseRenewalManager();
    private static String CONFIG_FILE = "jeri/file_classifier_server.config";

    public static void main(String[] stringArray) {
        new FileClassifierServer();
    }

    public FileClassifierServer() {
        Configuration configuration;
        try {
            this.impl = new ExtendedFileClassifierImpl();
        }
        catch (Exception exception) {
            System.err.println("New impl: " + exception.toString());
            System.exit(1);
        }
        String[] stringArray = new String[]{CONFIG_FILE};
        try {
            configuration = ConfigurationProvider.getInstance((String[])stringArray);
            Exporter exporter = (Exporter)configuration.getEntry("FileClassifierServer", "exporter", Exporter.class);
            System.out.println("exporter found");
            this.rmiProxy = exporter.export((Remote)this.impl);
            System.out.println("proxy exported");
        }
        catch (Exception exception) {
            System.err.println(exception.toString());
            exception.printStackTrace();
            System.exit(1);
        }
        System.setSecurityManager(new RMISecurityManager());
        this.smartProxy = new FileClassifierProxy(this.rmiProxy);
        configuration = null;
        try {
            configuration = new LookupDiscovery(LookupDiscovery.ALL_GROUPS);
        }
        catch (Exception exception) {
            System.err.println(exception.toString());
            System.exit(1);
        }
        configuration.addDiscoveryListener((DiscoveryListener)this);
    }

    public void discovered(DiscoveryEvent discoveryEvent) {
        ServiceRegistrar[] serviceRegistrarArray = discoveryEvent.getRegistrars();
        for (int i = 0; i < serviceRegistrarArray.length; ++i) {
            System.out.println("found registrars");
            ServiceRegistrar serviceRegistrar = serviceRegistrarArray[i];
            ServiceItem serviceItem = new ServiceItem(null, (Object)this.smartProxy, null);
            ServiceRegistration serviceRegistration = null;
            try {
                serviceRegistration = serviceRegistrar.register(serviceItem, Long.MAX_VALUE);
            }
            catch (RemoteException remoteException) {
                System.err.print("Register exception: ");
                remoteException.printStackTrace();
                continue;
            }
            try {
                System.out.println("service registered at " + serviceRegistrar.getLocator().getHost());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.leaseManager.renewUntil(serviceRegistration.getLease(), Long.MAX_VALUE, (LeaseListener)this);
        }
    }

    public void discarded(DiscoveryEvent discoveryEvent) {
    }

    public void notify(LeaseRenewalEvent leaseRenewalEvent) {
        System.out.println("Lease expired " + leaseRenewalEvent.toString());
    }
}

