/*
 * Decompiled with CFR 0.152.
 */
package clock.clock;

import clock.clock.ClockPane;
import clock.device.ClockDevice;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JFrame;

public class ClockFrame
extends JFrame
implements Runnable,
WindowListener {
    private static final String DEFAULT_TITLE = "Sample Clock";
    private ClockDevice clockDev;
    private ClockPane clockPane;
    private Thread timerThread = null;

    public ClockFrame(ClockDevice clockDevice) {
        this(clockDevice, DEFAULT_TITLE);
    }

    public ClockFrame(ClockDevice clockDevice, String string) {
        super(string);
        this.clockDev = clockDevice;
        this.getContentPane().setLayout(new BorderLayout());
        this.clockPane = new ClockPane(clockDevice);
        this.getContentPane().add((Component)this.clockPane, "Center");
        this.addWindowListener(this);
        this.pack();
        this.setVisible(true);
    }

    public ClockPane getClockPanel() {
        return this.clockPane;
    }

    public ClockDevice getClockDevice() {
        return this.clockDev;
    }

    public void run() {
        Thread thread = Thread.currentThread();
        while (this.timerThread == thread) {
            this.getClockPanel().repaint();
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void start() {
        this.timerThread = new Thread(this);
        this.timerThread.start();
    }

    public void stop() {
        this.timerThread = null;
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.stop();
        System.exit(0);
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

