/*
 * Decompiled with CFR 0.152.
 */
package audio.httpsource;

import audio.http.HttpMP3SourceImpl;
import audio.http.HttpOggSourceImpl;
import audio.http.HttpSourceImpl;
import audio.http.HttpWAVSourceImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RMISecurityManager;
import java.rmi.Remote;
import java.rmi.server.ExportException;
import net.jini.config.ConfigurationProvider;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceID;
import net.jini.discovery.DiscoveryManagement;
import net.jini.discovery.LookupDiscovery;
import net.jini.discovery.LookupDiscoveryManager;
import net.jini.export.Exporter;
import net.jini.id.Uuid;
import net.jini.id.UuidFactory;
import net.jini.lease.LeaseRenewalManager;
import net.jini.lookup.JoinManager;

public class FileServer {
    private Remote proxy;
    private HttpSourceImpl impl;
    private static String configFile;
    private Entry[] entries;
    private File serviceIDFile;
    private ServiceID serviceID;
    static /* synthetic */ Class class$net$jini$export$Exporter;
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$java$io$File;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        Object object;
        configFile = stringArray[0];
        FileServer fileServer = new FileServer(stringArray);
        Object object2 = object = new Object();
        synchronized (object2) {
            try {
                object.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public FileServer(String[] stringArray) {
        JoinManager joinManager;
        Exporter exporter;
        block12: {
            Object object;
            URL uRL = null;
            exporter = null;
            if (stringArray.length != 1) {
                System.err.println("Usage: FileServer config_file");
                System.exit(1);
            }
            String[] stringArray2 = stringArray;
            try {
                object = ConfigurationProvider.getInstance((String[])stringArray2);
                exporter = (Exporter)object.getEntry("HttpFile", "exporter", class$net$jini$export$Exporter == null ? (class$net$jini$export$Exporter = FileServer.class$("net.jini.export.Exporter")) : class$net$jini$export$Exporter);
                uRL = (URL)object.getEntry("HttpFile", "url", class$java$net$URL == null ? (class$java$net$URL = FileServer.class$("java.net.URL")) : class$java$net$URL);
                this.serviceIDFile = (File)object.getEntry("HttpFile", "serviceIDFile", class$java$io$File == null ? (class$java$io$File = FileServer.class$("java.io.File")) : class$java$io$File);
                this.getOrMakeServiceID(this.serviceIDFile);
                joinManager = Class.forName("[Lnet.jini.core.entry.Entry;");
                System.out.println(joinManager.toString());
                this.entries = (Entry[])object.getEntry("HttpFile", "entries", joinManager);
            }
            catch (Exception exception) {
                System.err.println(exception.toString());
                exception.printStackTrace();
                System.exit(1);
            }
            object = uRL.toString();
            try {
                if (((String)object).endsWith("wav")) {
                    this.impl = new HttpWAVSourceImpl(uRL);
                    break block12;
                }
                if (((String)object).endsWith("mp3")) {
                    this.impl = new HttpMP3SourceImpl(uRL);
                    break block12;
                }
                if (((String)object).endsWith("ogg")) {
                    this.impl = new HttpOggSourceImpl(uRL);
                    break block12;
                }
                System.out.println("Can't handle presentation type: " + uRL);
                return;
            }
            catch (MalformedURLException malformedURLException) {
                System.err.println(malformedURLException.toString());
                System.exit(1);
            }
        }
        try {
            this.proxy = exporter.export((Remote)this.impl);
        }
        catch (ExportException exportException) {
            System.err.println(exportException.toString());
            System.exit(1);
        }
        System.setSecurityManager(new RMISecurityManager());
        joinManager = null;
        try {
            LookupDiscoveryManager lookupDiscoveryManager = new LookupDiscoveryManager(LookupDiscovery.ALL_GROUPS, new LookupLocator[]{new LookupLocator("jini://jannote.jan.home/")}, null);
            joinManager = new JoinManager((Object)this.proxy, this.entries, this.serviceID, (DiscoveryManagement)lookupDiscoveryManager, new LeaseRenewalManager());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }

    private void getOrMakeServiceID(File file) {
        this.serviceID = null;
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file));
            this.serviceID = (ServiceID)objectInputStream.readObject();
            System.out.println("Got dir service id " + this.serviceID);
        }
        catch (Exception exception) {
            System.out.println("Couldn't get service IDs - generating new one");
            try {
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
                Uuid uuid = UuidFactory.generate();
                this.serviceID = new ServiceID(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
                objectOutputStream.writeObject(this.serviceID);
                objectOutputStream.close();
            }
            catch (Exception exception2) {
                System.out.println("Couldn't save ids");
                exception2.printStackTrace();
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

