/*
 * Decompiled with CFR 0.152.
 */
package pull;

import aumix.Aumix;
import common.AlreadyRecordingException;
import common.ContentSink;
import common.IncompatableSourceException;
import common.MimeType;
import common.NoSuchSourceException;
import common.Sink;
import common.Source;
import common.SourceSink;
import common.VolumeControl;
import java.io.InputStream;
import java.rmi.MarshalledObject;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Hashtable;
import net.jini.core.event.EventRegistration;
import net.jini.core.event.RemoteEvent;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.event.UnknownEventException;
import pull.PullSource;
import transport.HttpSinkImpl;
import transport.HttpSource;

public class SinkImpl
implements Sink,
VolumeControl,
Remote {
    private Source source;
    private boolean stopped;
    private CopyIO copyIO;
    private Hashtable listeners = new Hashtable();
    private int seqNum = 0;
    private Remote proxy;
    private MimeType contentType = null;

    public void setProxy(Remote remote) {
        this.proxy = remote;
    }

    public void record() throws RemoteException, AlreadyRecordingException {
        HttpSinkImpl httpSinkImpl = null;
        InputStream inputStream = null;
        if (this.source == null) {
            return;
        }
        if (this.source instanceof HttpSource) {
            httpSinkImpl = new HttpSinkImpl((HttpSource)this.source);
            inputStream = httpSinkImpl.getInputStream();
        } else if (this.source instanceof PullSource) {
            inputStream = ((PullSource)this.source).getInputStream();
        } else {
            return;
        }
        if (this.copyIO != null && !this.stopped) {
            throw new AlreadyRecordingException();
        }
        this.stopped = false;
        if (inputStream == null) {
            System.out.println("Couldn't get input stream");
            this.stopped = true;
            return;
        }
        this.copyIO = new CopyIO(this, inputStream, this.source);
        this.copyIO.start();
        System.out.println("Play returning");
    }

    public void stop() throws RemoteException {
        this.stopped = true;
        if (this.copyIO != null) {
            this.copyIO.stopRecord();
        }
    }

    public void contentStopped() {
        this.copyIO = null;
        this.fireNotify(1);
        System.out.println("Stopped");
    }

    public void addSource(Source source) throws IncompatableSourceException {
        this.source = source;
    }

    public void removeSource(Source source) throws RemoteException, NoSuchSourceException {
    }

    public EventRegistration addSinkListener(RemoteEventListener remoteEventListener, MarshalledObject marshalledObject) {
        System.out.println("Adding listener: " + remoteEventListener);
        this.listeners.put(remoteEventListener, marshalledObject);
        try {
            SourceSink sourceSink = (SourceSink)marshalledObject.get();
            System.out.println("SS source " + sourceSink.sources + " sink " + sourceSink.sink);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return new EventRegistration(0L, (Object)this.proxy, null, 0L);
    }

    public void removeSinkListener(RemoteEventListener remoteEventListener) {
        this.listeners.remove(remoteEventListener);
    }

    public void fireNotify(int n) {
        Enumeration enumeration = this.listeners.keys();
        System.out.println("Fire notify");
        while (enumeration.hasMoreElements()) {
            RemoteEventListener remoteEventListener = (RemoteEventListener)enumeration.nextElement();
            MarshalledObject marshalledObject = (MarshalledObject)this.listeners.get(remoteEventListener);
            RemoteEvent remoteEvent = new RemoteEvent((Object)this.proxy, (long)n, (long)this.seqNum++, marshalledObject);
            System.out.println("Updating listener " + remoteEventListener);
            try {
                remoteEventListener.notify(remoteEvent);
            }
            catch (UnknownEventException unknownEventException) {
            }
            catch (RemoteException remoteException) {}
        }
    }

    public void setVolume(int n) {
        Aumix.setVolume(n);
    }

    public int getVolume() {
        return Aumix.getVolume();
    }

    public int getMaxVolume() {
        return Aumix.getMaxVolume();
    }

    class CopyIO
    extends Thread {
        private SinkImpl sink;
        private ContentSink contentSink;

        CopyIO(SinkImpl sinkImpl2, InputStream inputStream, Source source) {
            this.contentSink = ContentSink.createSink(sinkImpl2, inputStream, source);
            this.sink = sinkImpl2;
        }

        public void stopRecord() {
            if (this.contentSink != null) {
                this.contentSink.stop();
            }
        }

        public void run() {
            this.contentSink.record();
            try {
                this.sink.stop();
            }
            catch (RemoteException remoteException) {
                remoteException.printStackTrace();
            }
        }
    }
}

