/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.GUIClient;
import client.LabelCellRenderer;
import client.PlayFrame;
import common.AlreadyPlayingException;
import common.AlreadyRecordingException;
import common.ComparableServiceItem;
import common.NotRecordingException;
import common.Sink;
import common.Source;
import common.SourceSink;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.rmi.MarshalledObject;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Enumeration;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import net.jini.core.event.RemoteEvent;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.lookup.ServiceItem;

public class ClientFrame
extends JFrame
implements ActionListener,
ListSelectionListener,
TreeSelectionListener,
TreeExpansionListener,
RemoteEventListener {
    private GUIClient client;
    private JList sources = new JList();
    private JList sinks = new JList();
    private JTree directories = new JTree();
    private JButton playBtn = new JButton("Play");
    private JButton stopBtn = new JButton("Stop");
    private Remote proxy;

    public ClientFrame() {
        super("Audio Router");
        this.makeLayout();
        this.addListeners();
        this.setupLists();
    }

    public void setClient(GUIClient gUIClient) {
        this.client = gUIClient;
    }

    private void makeLayout() {
        Container container = this.getContentPane();
        container.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        JTabbedPane jTabbedPane = new JTabbedPane();
        container.add((Component)jPanel, "South");
        container.add((Component)jTabbedPane, "Center");
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        jTabbedPane.add("Folders", jPanel2);
        jTabbedPane.add("Sources", jPanel3);
        jTabbedPane.add("Sinks", jPanel4);
        jPanel2.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().setView(this.directories);
        jPanel2.add((Component)jScrollPane, "Center");
        jPanel3.setLayout(new BorderLayout());
        JScrollPane jScrollPane2 = new JScrollPane();
        jScrollPane2.getViewport().setView(this.sources);
        jPanel3.add((Component)jScrollPane2, "Center");
        jPanel4.setLayout(new BorderLayout());
        JScrollPane jScrollPane3 = new JScrollPane();
        jScrollPane3.getViewport().setView(this.sinks);
        jPanel4.add((Component)jScrollPane3, "Center");
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayout(1, 3));
        jPanel5.add(this.playBtn);
        jPanel.add((Component)jPanel5, "Center");
    }

    private void addListeners() {
        this.playBtn.addActionListener(this);
        this.stopBtn.addActionListener(this);
        this.directories.addTreeSelectionListener(this);
        this.directories.addTreeExpansionListener(this);
        this.sources.addListSelectionListener(this);
        this.sinks.addListSelectionListener(this);
    }

    private void setupLists() {
        LabelCellRenderer labelCellRenderer = new LabelCellRenderer();
        this.directories.setCellRenderer(labelCellRenderer);
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Directories");
        this.directories.setModel(new DefaultTreeModel(defaultMutableTreeNode));
        this.sources.setCellRenderer(labelCellRenderer);
        this.sources.setModel(new DefaultListModel());
        this.sinks.setCellRenderer(labelCellRenderer);
        this.sinks.setModel(new DefaultListModel());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.playBtn) {
            Object[] objectArray = this.sources.getSelectedValues();
            if (objectArray.length == 0) {
                JOptionPane.showMessageDialog(null, "No source selected", "Source is null", 0);
                return;
            }
            Object[] objectArray2 = this.sinks.getSelectedValues();
            if (objectArray2 == null) {
                JOptionPane.showMessageDialog(null, "No sink selected", "Sink is null", 0);
                return;
            }
            ServiceItem[] serviceItemArray = new ServiceItem[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                serviceItemArray[i] = (ServiceItem)objectArray[i];
            }
            ServiceItem[] serviceItemArray2 = new ServiceItem[objectArray2.length];
            for (int i = 0; i < objectArray2.length; ++i) {
                serviceItemArray2[i] = (ServiceItem)objectArray2[i];
            }
            new PlayFrame(this.client).play(serviceItemArray, serviceItemArray2[0]);
        } else if (actionEvent.getSource() == this.stopBtn) {
            // empty if block
        }
    }

    private void play(ServiceItem[] serviceItemArray, ServiceItem serviceItem) {
        if (serviceItemArray == null || serviceItemArray.length == 0) {
            System.out.println("Play: null sources");
            return;
        }
        Source source = (Source)serviceItemArray[0].service;
        Sink sink = (Sink)serviceItem.service;
        ServiceItem[] serviceItemArray2 = new ServiceItem[serviceItemArray.length - 1];
        for (int i = 0; i < serviceItemArray2.length; ++i) {
            serviceItemArray2[i] = serviceItemArray[i + 1];
        }
        MarshalledObject<SourceSink> marshalledObject = null;
        try {
            marshalledObject = new MarshalledObject<SourceSink>(new SourceSink(serviceItemArray2, serviceItem));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        try {
            if (this.proxy == null) {
                // empty if block
            }
            System.out.println("Added source " + source + " proxy " + this.proxy);
            sink.addSinkListener((RemoteEventListener)this.proxy, marshalledObject);
            System.out.println("Added sink " + sink + " proxy " + this.proxy + " handback " + marshalledObject.get().sources);
        }
        catch (RemoteException remoteException) {
            remoteException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            System.out.println("Setting sink to: " + sink);
            source.addSink(sink);
            System.out.println("Setting source to: " + source);
            sink.addSource(source);
            System.out.println("Playing" + serviceItemArray[0].attributeSets[0]);
            source.play();
            sink.record();
        }
        catch (AlreadyPlayingException alreadyPlayingException) {
            JOptionPane.showMessageDialog(null, "Source already playing", "Play error", 0);
        }
        catch (AlreadyRecordingException alreadyRecordingException) {
            JOptionPane.showMessageDialog(null, "Sink already recording", "Record error", 0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void stop(ServiceItem[] serviceItemArray, ServiceItem serviceItem) {
        System.out.println("Stopping");
        Sink sink = (Sink)serviceItem.service;
        try {
            sink.stop();
        }
        catch (NotRecordingException notRecordingException) {
            JOptionPane.showMessageDialog(null, "Sink not recording", "Record stop error", 0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void notify(RemoteEvent remoteEvent) {
        Object object = remoteEvent.getSource();
        System.out.println("Updating " + object);
        if (object instanceof Sink && remoteEvent.getID() == 1L) {
            System.out.println("Sink stopped event");
            Sink sink = (Sink)object;
            try {
                sink.removeSinkListener((RemoteEventListener)this.proxy);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
            MarshalledObject marshalledObject = remoteEvent.getRegistrationObject();
            SourceSink sourceSink = null;
            try {
                sourceSink = (SourceSink)marshalledObject.get();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
            ServiceItem[] serviceItemArray = sourceSink.sources;
            ServiceItem serviceItem = sourceSink.sink;
            System.out.println("  stop -> play: sources " + serviceItemArray + " sink " + sink);
            this.play(serviceItemArray, serviceItem);
        } else if (object instanceof Source && remoteEvent.getID() == 1L) {
            System.out.println("Source stopped event");
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
    }

    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        System.out.println("Tree collapsed " + treeExpansionEvent.getPath());
    }

    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        System.out.println("Tree expanded " + treeExpansionEvent.getPath());
    }

    public DefaultMutableTreeNode addDirectory(ServiceItem serviceItem) {
        DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.directories.getModel();
        DefaultMutableTreeNode defaultMutableTreeNode = this.insertTreeItem(new ComparableServiceItem(serviceItem), defaultTreeModel);
        return defaultMutableTreeNode;
    }

    public void addDirectoryElement(Object object, ServiceItem serviceItem) {
        final DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
        final DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(new ComparableServiceItem(serviceItem));
        Runnable runnable = new Runnable(){

            public void run() {
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void addSource(ServiceItem serviceItem) {
        DefaultListModel defaultListModel = (DefaultListModel)this.sources.getModel();
        this.insertListItem(new ComparableServiceItem(serviceItem), defaultListModel);
    }

    public void addSink(ServiceItem serviceItem) {
        DefaultListModel defaultListModel = (DefaultListModel)this.sinks.getModel();
        this.insertListItem(new ComparableServiceItem(serviceItem), defaultListModel);
    }

    public void removeDirectory(ServiceItem serviceItem) {
    }

    public void removeSource(final ServiceItem serviceItem) {
        final DefaultListModel defaultListModel = (DefaultListModel)this.sources.getModel();
        Runnable runnable = new Runnable(){

            public void run() {
                if (defaultListModel.removeElement(new ComparableServiceItem(serviceItem))) {
                    System.err.println("Removed source elmt " + serviceItem.service);
                } else {
                    System.err.println("Failed to remove source elmt " + serviceItem.service);
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    public void removeSink(final ServiceItem serviceItem) {
        final DefaultListModel defaultListModel = (DefaultListModel)this.sinks.getModel();
        Runnable runnable = new Runnable(){

            public void run() {
                if (defaultListModel.removeElement(new ComparableServiceItem(serviceItem))) {
                    System.err.println("Removed sink elmt " + serviceItem.service);
                } else {
                    System.err.println("Failed to remove sink elmt " + serviceItem.service);
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    private void insertListItem(final ComparableServiceItem comparableServiceItem, final DefaultListModel defaultListModel) {
        Runnable runnable = new Runnable(){

            public void run() {
                Enumeration enumeration = defaultListModel.elements();
                int n = 0;
                while (enumeration.hasMoreElements() && comparableServiceItem.compareTo(enumeration.nextElement()) > 0) {
                    ++n;
                }
                defaultListModel.add(n, comparableServiceItem);
            }
        };
        try {
            SwingUtilities.invokeAndWait(runnable);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
    }

    private DefaultMutableTreeNode insertTreeItem(final ComparableServiceItem comparableServiceItem, final DefaultTreeModel defaultTreeModel) {
        final DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(comparableServiceItem);
        Runnable runnable = new Runnable(){

            public void run() {
                DefaultMutableTreeNode defaultMutableTreeNode3;
                System.out.println("Inserting tree node " + comparableServiceItem);
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultTreeModel.getRoot();
                Enumeration<TreeNode> enumeration = defaultMutableTreeNode2.children();
                int n = 0;
                while (enumeration.hasMoreElements() && comparableServiceItem.compareTo((defaultMutableTreeNode3 = (DefaultMutableTreeNode)enumeration.nextElement()).getUserObject()) > 0) {
                    ++n;
                }
                defaultMutableTreeNode2.insert(defaultMutableTreeNode, n);
            }
        };
        try {
            SwingUtilities.invokeAndWait(runnable);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        return defaultMutableTreeNode;
    }
}

