
/**
 * ServiceIDFactory.java
 *
 *
 * Created: Mon Jun 30 08:09:04 2003
 *
 * @author <a href="mailto: jan@newmarch.name">jan newmarch</a>
 * @version
 */

package util;

import net.jini.core.lookup.ServiceID;
import java.util.StringTokenizer;

public class ServiceIDFactory {
    private ServiceIDFactory (){
    }

    public static ServiceID getServiceID(String id) {
	if (id == null)
	    return null;

	StringTokenizer st = new StringTokenizer(id, "-");
	try {
	    long low = Long.parseLong(st.nextToken(), 16);
	    long mid = Long.parseLong(st.nextToken(), 16);
	    long version = Long.parseLong(st.nextToken(), 16);
	    long variant = Long.parseLong(st.nextToken(), 16);
	    long node = Long.parseLong(st.nextToken(), 16);
	    
	    long hi = (low << 32) | (mid << 16) | version;
	    long lo = (variant << 48) | node;
	    return new ServiceID(hi, lo);
	} catch(Exception e) {
	    return null;
	}
    }
}// ServiceIDFactory
