
package client;

import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import net.jini.discovery.LookupDiscovery;
import net.jini.discovery.DiscoveryListener;
import net.jini.discovery.DiscoveryEvent;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.core.lookup.ServiceTemplate;
import net.jini.core.lookup.ServiceMatches;
import net.jini.core.lookup.ServiceItem;

/**
 * BasicServiceLister
 *
 *
 * Created: Aug 10 2004
 *
 * @author Jan Newmarch
 * @version 1.0
 */

public class BasicServiceLister implements DiscoveryListener {

    public static void main(String argv[]) {
	new BasicServiceLister();

        // stay around long enough to receive replies
        try {
            Thread.currentThread().sleep(100000L);
        } catch(java.lang.InterruptedException e) {
            // do nothing
        }
    }

    public BasicServiceLister() {
	System.setSecurityManager(new RMISecurityManager());

	LookupDiscovery discover = null;
        try {
            discover = new LookupDiscovery(LookupDiscovery.ALL_GROUPS);
        } catch(Exception e) {
            System.err.println(e.toString());
            System.exit(1);
        }

        discover.addDiscoveryListener(this);

    }
    
    public void discovered(DiscoveryEvent evt) {

        ServiceRegistrar[] registrars = evt.getRegistrars();
	Class [] classes = new Class[] {Object.class};
	ServiceTemplate template = new ServiceTemplate(null, classes, 
						       null);
 
        for (int n = 0; n < registrars.length; n++) {
            ServiceRegistrar registrar = registrars[n];
	    System.out.print("Lookup service found at "); 
	    try {
		System.out.println(registrar.getLocator().getHost());
	    } catch(RemoteException e) {
		// ignore
	    }
	    ServiceMatches matches = null;
	    try {
		matches = registrar.lookup(template, Integer.MAX_VALUE);
	    } catch(RemoteException e) {
		e.printStackTrace();
		continue;
	    }
	    ServiceItem[] items = matches.items;
	    for (int m = 0; m < items.length; m++) {
		printObject(items[m].service);
	    }
	}
    }

    public void discarded(DiscoveryEvent evt) {
	// empty
    }

    private void printObject(Object obj) {
	System.out.println("Object is " + obj.toString());
    }
} // BasicServiceLister
