
/**
 * TunerSource.java
 *
 *
 * Created: Sun Jun 29 10:25:18 2003
 *
 * @author <a href="mailto: jan@newmarch.name">jan newmarch</a>
 * @version
 */

package tuner;

import common.*;
import java.io.*;
import java.util.Arrays;
import java.util.ArrayList;

import net.jini.lookup.JoinManager;
import net.jini.core.lookup.ServiceID;
import net.jini.lease.LeaseRenewalManager;
import net.jini.lookup.entry.*;
import net.jini.core.entry.Entry;
import java.rmi.RMISecurityManager;
import java.rmi.Remote;
import net.jini.core.discovery.LookupLocator;
import net.jini.discovery.LookupDiscovery;
import java.net.InetSocketAddress;
import net.jini.discovery.LookupDiscoveryManager;
import java.rmi.RemoteException;
import net.jini.lookup.ServiceIDListener;
import net.jini.core.lookup.ServiceID;

import net.jini.id.UuidFactory;
import net.jini.id.Uuid;

import net.jini.config.*; 
import net.jini.export.*; 
import com.sun.jini.config.Config;
				       
import java.util.Vector;

import http.*;
import transport.*;

public class TunerSource implements ServiceIDListener  {
    protected Remote proxy;
    protected TcpSourceImpl impl;

    // info pulled out of a Configuration
    private InetSocketAddress sockAddr = null;
    private Exporter exporter = null;
    private ServiceID serviceID = null;
    private Configuration config;
    private File serviceIDFile;
    private Entry[] entries;

    // JoinManager's to keep the services alive
    private JoinManager joinMgr;
    private LeaseRenewalManager leaseRenewalManager;

    public TunerSource(String configFile, LeaseRenewalManager leaseRenewalManager) {
	this.leaseRenewalManager = leaseRenewalManager;

	getConfiguration(configFile);
	makeService();
    }

    private void getConfiguration(String name) {
	String[] configArgs = new String[] {name};
	try {
	    // get the configuration (by default a FileConfiguration) 
	    config = ConfigurationProvider.getInstance(configArgs); 
	} catch(Exception e) {
	    System.err.println(e.toString());
	    e.printStackTrace();
	    System.exit(1);
	}

	try {
	    serviceIDFile = (File) config.getEntry("TcpTunerServer",
						   "serviceIDFile",
						   File.class,
						   null);
	    if (serviceIDFile != null) {
		// getOrMakeServiceIDs(serviceIDFile);
	    }
	} catch(Exception e) {
	    System.err.println("Config error: " + e.toString());
	}

	try {
	    entries = (Entry[]) config.getEntry("TcpTunerServer",
						"entries",
						Entry[].class,
						null);
	} catch(Exception e) {
	    System.err.println("Config error: " + e.toString());
	}

	try {
	    sockAddr = (InetSocketAddress) config.getEntry("TcpTunerServer",
							   "sockAddr",
							   InetSocketAddress.class,
							   null);
	} catch(Exception e) {
	    System.err.println("Config error: " + e.toString());
	}
    }

    private void makeService() {
	try {
	    exporter = (Exporter) config.getEntry( "TcpTunerServer", 
						   "exporter", 
						   Exporter.class);
	} catch(Exception e) {
	    System.err.println(e.toString());
	    e.printStackTrace();
	    System.exit(1);
	}

	impl = new TcpSourceImpl(sockAddr);

	try {
	    System.out.println("Export dir using exporter " + exporter);
	    // export a tcp tuner object
	    proxy = exporter.export(impl);
	} catch(java.rmi.server.ExportException e) {
	    System.err.println(e.toString());
	    e.printStackTrace();
	    System.exit(1);
	}
	
	joinMgr = registerService(proxy, serviceID, entries);
     }

    private JoinManager registerService(Remote proxy, ServiceID serviceID, Entry[]  entries) {
	JoinManager joinMgr = null;
	try {
	    LookupDiscoveryManager mgr = 
		new LookupDiscoveryManager(LookupDiscovery.ALL_GROUPS,
					   //new LookupLocator[] {
					   //    new LookupLocator("jini://jannote.jan.home/")},
					   null,
					   // unicast locators
					   null); // DiscoveryListener
	    if (serviceID != null) {
		System.out.println("Registering with id " + serviceID);
		joinMgr = new JoinManager(proxy,     // service proxy
					  entries,   // attr sets
					  serviceID, // ServiceID
					  mgr,       // DiscoveryManager
					  leaseRenewalManager);

	    } else {
		joinMgr = new JoinManager(proxy,    // service proxy
					  entries,  // attr sets
					  this,     // ServiceIDListener
					  mgr,      // DiscoveryManager
					  leaseRenewalManager);
	    }
	} catch(Exception e) {
	    e.printStackTrace();
	    System.exit(1);
	}
	return joinMgr;
    }

    public void serviceIDNotify(ServiceID serviceID) {
	// called as a ServiceIDListener
	System.out.println("got service ID " + serviceID.toString());
	
	// Should save the id to permanent storage
	// but which is the config file?
	// saveID(configFile, serviceID.toString());
    }

    public static void main(String[] argv) {
	LeaseRenewalManager leaseRenewalManager = new LeaseRenewalManager();

	// install suitable security manager
	System.setSecurityManager(new RMISecurityManager());

	TunerSource tunerSrc = new TunerSource(argv[0], 
					     leaseRenewalManager);

       // stay around forever
        Object keepAlive = new Object();
        synchronized(keepAlive) {
            try {
                keepAlive.wait();
            } catch(InterruptedException e) {
                // do nothing
            }
        }
    }
}// TunerSource
