
/**
 * DirDirectory.java
 *
 *
 * Created: Sun Jun 29 10:25:18 2003
 *
 * @author <a href="mailto: jan@newmarch.name">jan newmarch</a>
 * @version
 */

package filedir;

import common.*;
import java.io.*;
import java.rmi.RMISecurityManager;
import java.util.Vector;
import net.jini.lease.LeaseRenewalManager;

/**
 * Read a (file) directory for a list of .cfg files
 * each of which should list the specs for a directory 
 * of services, and publish each directory of services
 */
  
public class DirDirectory {
    
    private Vector dirs = new Vector();

    public DirDirectory(String dirStr) {
	LeaseRenewalManager leaseRenewalManager = new LeaseRenewalManager();
 
	File dir = new File(dirStr);
	String[] files = dir.list(new java.io.FilenameFilter() {
		public boolean accept(File d, String name) {
		    System.out.println("Checking file " + name);
		    if (name.endsWith(".cfg"))
			return true;
		    else
			return false;
		}
	    });

	System.out.println("Dir length: " + files.length);
	for (int n = 0; n  < files.length; n++) {
	    dirs.add(
		     new FileDirectory(dirStr + "/" + files[n],
				       leaseRenewalManager)
		     );
	}
    }

    public static void main(String[] argv) {

	System.setSecurityManager(new RMISecurityManager());

	DirDirectory dd = new DirDirectory(argv[0]);

       // stay around forever
        Object keepAlive = new Object();
        synchronized(keepAlive) {
            try {
                keepAlive.wait();
            } catch(InterruptedException e) {
                // do nothing
            }
        }
    }
}// FileDirectory
