
import java.io.*;
import java.text.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;

import common.ServiceFinder;

import java.rmi.RMISecurityManager;
import net.jini.discovery.LookupDiscovery;
import net.jini.core.lookup.ServiceTemplate;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.discovery.LookupLocator;
import net.jini.discovery.LookupDiscoveryManager;
import net.jini.lookup.ServiceDiscoveryManager;
import net.jini.lease.LeaseRenewalManager;
import net.jini.core.lookup.ServiceRegistrar;


/**
 * @author Jan Newmarch
 */

public class JiniFinder extends HttpServlet {

    protected ServiceFinder finder;

    public void init() {
	init(new PrintWriter(System.err));
    }

    public void init(PrintWriter out) {
        LookupLocator lookup = null;
	ServiceRegistrar registrar = null;

        System.setSecurityManager(new RMISecurityManager());

        try {
            lookup = new LookupLocator("jini://localhost");
	    registrar = lookup.getRegistrar();
        } catch(Exception e) {
            out.println("First lookup failed: " + e.toString());
        }

  
        Class [] classes = new Class[] {ServiceFinder.class};
        ServiceTemplate template = new ServiceTemplate(null, classes, 
                                                       null);

	Object service = null;
	try {
	    service = registrar.lookup(template);
	} catch(Exception e) {
	    out.println(e.toString());
	}
        if (service == null) {
            // couldn't find a service in time
            out.println("Jini service finder is not running");
            // System.exit(1); - may kill tomcat!
        }

        // Get the service
        finder = (ServiceFinder) service;
    }

    public void doGet(HttpServletRequest request,
                      HttpServletResponse response)
        throws IOException, ServletException
    {

        response.setContentType("text/html");

        PrintWriter out = response.getWriter();
        out.println("<html>");
        out.println("<head>");

        out.println("<title>" + "Jini Service Finder" + "</title>");
        out.println("</head>");
        out.println("<body>");
	out.println("<center> <h1> Jini Service Finder </h1> </center>");

	if (finder == null) {
	    // out.println("<br><em>Service finder null</em></br>");
	    init(out);
	}

	printServices(out);

        HttpSession session = request.getSession();
	session.setAttribute("ServiceFinder", finder);

        out.println("</body>");
        out.println("</html>");
    }

    public void doPost(HttpServletRequest request,
                      HttpServletResponse response)
        throws IOException, ServletException
    {
        doGet(request, response);
    }

    void printServices(PrintWriter out) {
	ServiceItem[] services = null;
	try {
	    services = finder.getServices();
	} catch(java.rmi.RemoteException e) {
	    out.println("<pre>" + e.toString() + "</pre>");
	    out.println("</body>\n</html>");
	    return;
	}
	out.println("<center>");
	out.println("<table border=1> <tr> <th> Services </ht> </tr>");
	for (int n = 0; n < services.length; n++) {
	    ServiceItem serviceItem = services[n];
	    out.println("<tr> <td> " + serviceToString(serviceItem) +
			"</td> </tr>");
	}
	out.println("</table>");
	out.println("</center>");
    }

    String serviceToString(ServiceItem item) {
	Object service = item.service;
	if (service == null) {
	    return "<null>";
	}
	String name = service.getClass().getName();
	return name;
    }
}




