
/**
 * RCXPortProxy.java
 *
 *
 * Created: Wed Jun  2 23:30:07 1999
 *
 * @author Jan Newmarch
 * @version 1.0
 */

package rcx.jini;

import net.jini.core.event.RemoteEvent;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.event.UnknownEventException;
import rcx.*;

public class RCXPortProxy implements RCXPortInterface/*, RemoteEventListener*/ {

    protected RemoteRCXPort service = null;

    public RCXPortProxy(RemoteRCXPort serv) {
	service = serv;
    }

    public boolean write(byte[] commands) 
	throws java.rmi.RemoteException {
	return service.write(commands);
    }

    public byte[] parseString(String str) 
	throws java.rmi.RemoteException {
	return service.parseString(str);
    }

    public void addListener(RemoteEventListener listener) {
	try {
	    service.addListener(listener);
	} catch(Exception e) {
	    e.printStackTrace();
	}
    }

    public byte[] getMessage(long seqNo) 
	throws java.rmi.RemoteException {
	return service.getMessage(seqNo);
    }

    public String getError(long seqNo)
	throws java.rmi.RemoteException {
	return service.getError(seqNo);
    }

} // RCXPortProxy
