
/**
 * NotQuiteCImpl.java
 *
 *
 * Created: Wed Oct 27 21:08:01 1999
 *
 * @author Jan Newmarch
 * @version 1.0
 */

package rcx.jini;

import java.rmi.server.UnicastRemoteObject;
import java.rmi.RemoteException;
import java.io.*;

public class NotQuiteCImpl extends UnicastRemoteObject
    implements RemoteNotQuiteC {

    protected final int SIZE = 1<<15; // 32k - the size of the RCX memory

    public NotQuiteCImpl() throws RemoteException {
    }

    public byte[] compile(String program)
	throws CompileException {

	// This is the input file we read from - it is the output from nqc
	File inFile = null;
	//  This is the output file that we write to - it is the input to nqc
	File outFile = null;
	byte[] buff = new byte[SIZE];

	try {
	    outFile = File.createTempFile("jini", ".nqc");
	    inFile = File.createTempFile("jini", ".rcx");
	    OutputStreamWriter out = new OutputStreamWriter(
					 new FileOutputStream(
					     outFile));

	    out.write(program);
	    out.close();

	    Process p = Runtime.getRuntime().exec("nqc -O" + 
						  inFile.getAbsolutePath() +
						  " " + outFile.getAbsolutePath());

	    int status = p.waitFor();
	    if (status != 0) {
		BufferedReader err = new BufferedReader(
					 new InputStreamReader(p.
					      getErrorStream()));
		StringBuffer errBuff = new StringBuffer();
		String line;
		while ((line = err.readLine()) != null) {
		    errBuff.append(line + '\n');
		}
		throw new CompileException(errBuff.toString());
	    }

	    DataInputStream compiled = new DataInputStream(new
						FileInputStream(outFile));
	    int nread = compiled.read(buff);
	    byte[] result = new byte[nread];
	    System.arraycopy(buff, 0, result, 0, nread);
	    return result;
	} catch(IOException e) {
	    throw new CompileException(e.toString());
	} catch(InterruptedException e) {
	    throw new CompileException(e.toString());
	} finally {
	    // cleanup files even if exceptions thrown
	    if (inFile != null) {
		inFile.delete();
	    }
	    if (outFile != null) {
		outFile.delete();
	    }
	}
    }

    public static void main(String[] argv) {
	String program = "task main() {\n" +
                         "     OnFwd(OUT_A);\n" +
                         "     Wait(100);\n" +
                         "     Off(OUT_A);\n" +
                         "}";
	NotQuiteCImpl compiler = null;
	try {
	    compiler = new NotQuiteCImpl();
	    byte[] bytes = compiler.compile(program);
	} catch(Exception e) {
	    e.printStackTrace();
	}
    }
} // NotQuiteCImpl
