
package rcx.jini;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.event.RemoteEvent;
import net.jini.core.event.UnknownEventException;
import java.net.URL;
import java.rmi.RemoteException;

class CarJFrame extends JFrame
    implements RemoteEventListener, ActionListener {

    public static final int STOPPED = 1;
    public static final int FORWARDS = 2;
    public static final int BACKWARDS = 4;

    protected int state = STOPPED;
     
    protected RCXPortInterface port = null;
    
    JFrame frame;
    JTextArea text;
    
    public CarJFrame(RCXPortInterface port) {
	super() ;
	this.port = port;
	
	frame = new JFrame("Lego MindStorms");
	Container content = frame.getContentPane();
	JLabel label = null;
	ImageIcon icon = null;
	try {
	    icon = new ImageIcon(new 
			 URL("http://www.legomindstorms.com/images/home_logo.jpg"));
	    switch (icon.getImageLoadStatus()) {
	    case MediaTracker.ABORTED:
	    case MediaTracker.ERRORED:
		System.out.println("Error");
		icon = null;
		break;
	    case MediaTracker.COMPLETE:
		System.out.println("Complete");
		break;
	    case MediaTracker.LOADING:
		System.out.println("Loading");
		break;
	    }
	} catch(java.net.MalformedURLException e) {
	    e.printStackTrace();
	}
	if (icon != null) {
	    label = new JLabel(icon);
	} else {
	    label = new JLabel("MINDSTORMS");
	}

	JPanel pane = new JPanel();	    
	pane.setLayout(new GridLayout(2, 3));
	
	content.add(label, "North");
	content.add(pane, "Center");
	
	JButton btn = new JButton("Forward");
	pane.add(btn);
	btn.addActionListener(this);
	
	btn = new JButton("Stop");
	pane.add(btn);
	btn.addActionListener(this);
	
	btn = new JButton("Back");
	pane.add(btn);
	btn.addActionListener(this);
	
	btn = new JButton("Left");
	pane.add(btn);
	btn.addActionListener(this);
	
	label = new JLabel("");
	pane.add(label);
	
	btn = new JButton("Right");
	pane.add(btn);
	btn.addActionListener(this);
	
	frame.pack();
	frame.setVisible(true);
    }

    public void sendCommand(String comm) {
	byte[] command;
	try {
	    command = port.parseString(comm);
	    if (! port.write(command)) {
		System.err.println("command failed");
	    }
	} catch(RemoteException e) {
	    e.printStackTrace();
	}
    }

    public void forwards() {
	sendCommand("e1 85");
	sendCommand("21 85");
	state = FORWARDS;
    }
    
    public void backwards() {
	sendCommand("e1 45");
	sendCommand("21 85");
	state = BACKWARDS;
    }
    
    public void stop() {
	sendCommand("21 45");
	state = STOPPED;
    }
    
    public void restoreState() {
	if (state == FORWARDS)
	    forwards();
	else if (state == BACKWARDS)
	    backwards();
	else
	    stop();
    }
    
    public void actionPerformed(ActionEvent evt) {
	String name = evt.getActionCommand();
	byte[] command;
	
	if (name.equals("Forward")) {
	    forwards();
	} else  if (name.equals("Stop")) {
	    stop();
	} else  if (name.equals("Back")) {
	    backwards();
	} else  if (name.equals("Left")) {
	    sendCommand("e1 84");
	    sendCommand("21 84");
	    sendCommand("21 41");
	    try {
		Thread.sleep(100);
	    } catch(InterruptedException e) {
	    }
	    restoreState();
	    
	} else  if (name.equals("Right")) {
	    sendCommand("e1 81");
	    sendCommand("21 81");
	    sendCommand("21 44");
	    try {
		Thread.sleep(100);
	    } catch(InterruptedException e) {
	    }
	    restoreState();
	}
    }
    
    public void notify(RemoteEvent evt) throws UnknownEventException, 
	java.rmi.RemoteException {
	// System.out.println(evt.toString());
	
	long id = evt.getID();
	long seqNo = evt.getSequenceNumber();
	if (id == RCXPortInterface.MESSAGE_EVENT) {
	    byte[] message = port.getMessage(seqNo);
	    StringBuffer sbuffer = new StringBuffer();
	    for(int n = 0; n < message.length; n++) {       
		int newbyte = (int) message[n];
		if (newbyte < 0) {
		    newbyte += 256;
		}
		sbuffer.append(Integer.toHexString(newbyte) + " ");
	    }
	    System.out.println("MESSAGE: " + sbuffer.toString());
	} else if (id == RCXPortInterface.ERROR_EVENT) {
	    System.out.println("ERROR: " + port.getError(seqNo));
	} else {
	    throw new UnknownEventException("Unknown message " + evt.getID());
	}
    }
}




