package ejb;

/**
 * FileClassifierClient.java
 *
 *
 * Created: Sun May 14 03:34:58 2000
 *
 * @author Jan Newmarch
 * @version 1.0
 */

import javax.ejb.*;
import javax.naming.*;
import java.util.Properties;

public class FileClassifierClient  {

    private String user = null;
    private String password = "";
    private String url = "t3://localhost:7001";

    public static void main(String[] args) {
	new FileClassifierClient(args);
    }

    public FileClassifierClient(String[] args) {
	parseArgs(args);
	try {
	    Context ctx = getInitialContext();
	    FileClassifierHome home = (FileClassifierHome) 
		ctx.lookup("ejb.FileClassifierHome");
	    FileClassifier classifier = home.create();
	    System.out.println("Type of file a.txt is " +
			       classifier.getMIMEType("a.txt").toString());
	} catch(Exception e) {
	    e.printStackTrace();
	}
    }

    private void parseArgs(String[] args) {
	if ((args == null) || (args.length == 0))
	    return;
	for (int n = 0; n < args.length; n++) {
	    if (args[n].equals("-url")) {
		url = args[++n];
	    } else if (args[n].equals("-user")) {
		user = args[++n];
	    } else if (args[n].equals("-password")) {
		password = args[++n];
	    }
	}
    }

    private Context getInitialContext() throws Exception {
	Properties props = new Properties();
	props.put(Context.INITIAL_CONTEXT_FACTORY,
		  "weblogic.jndi.T3InitialContextFactory");
	props.put(Context.PROVIDER_URL, url);
	if (user != null) {
	    props.put(Context.SECURITY_PRINCIPAL, user);
	    props.put(Context.SECURITY_CREDENTIALS, password);
	}
	return new InitialContext(props);
    }
} // FileClassifierClient
