
/**
 * RoomBookingBridgeServer.java
 *
 *
 * Created: Thu Aug 19 22:37:39 1999
 *
 * @author Jan Newmarch
 * @version 1.1
 *  uses Jini 1.1 JoinManager
 */
package corba.RoomBookingImpl;

import org.omg.CosNaming.*;
import org.omg.CosNaming.NamingContextPackage.*;
import org.omg.CORBA.*;
// import com.sun.jini.lookup.JoinManager;
import net.jini.lookup.JoinManager;
import net.jini.core.lookup.ServiceID;
// import com.sun.jini.lookup.ServiceIDListener;
// import com.sun.jini.lease.LeaseRenewalManager;
import net.jini.lookup.ServiceIDListener;
import net.jini.lease.LeaseRenewalManager;
import net.jini.discovery.LookupDiscovery;
import net.jini.discovery.LookupDiscoveryManager;

public class RoomBookingBridgeServer implements ServiceIDListener {
    
    public RoomBookingBridgeServer(String[] argv) {
	
        JoinManager joinMgr = null;
        try {
	    LookupDiscoveryManager mgr = 
		new LookupDiscoveryManager(LookupDiscovery.ALL_GROUPS,
					   null /* unicast locators */,
					   null /* DiscoveryListener */);
            joinMgr = new JoinManager(new RoomBookingBridgeImpl(argv),
                                      null,
                                      this,
				      mgr,
                                      new LeaseRenewalManager());
        } catch(Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public void serviceIDNotify(ServiceID serviceID) {
        System.out.println("got service ID " + serviceID.toString());
    }
    
    public static void main(String[] argv) {
        new RoomBookingBridgeServer(argv);

        // stay around long enough to receive replies
        try {
            Thread.currentThread().sleep(1000000L);
        } catch(java.lang.InterruptedException e) {
            // do nothing
        }
    }
    
} // RoomBookingBridgeServer

