
/**
 * JavaRoomImpl.java
 *
 *
 * Created: Thu Aug 26 15:33:24 1999
 *
 * @author Jan Newmarch
 * @version 1.0
 */
package corba.RoomBookingImpl;

import corba.RoomBooking.*;
import corba.common.*;
import org.omg.CORBA.*;

/**
 * A portable Java object representing a CORBA object.
 * It carries a stringified version of the CORBA reference
 * for reconstruction on JVM's which have a CORBA orb.
 * It exposes the attributes of the CORBA object to non-CORBA
 * applications by copying the attribute values on construction.
 */
public class JavaRoomImpl implements JavaRoom {
    protected String name;
    protected String corbaObj;

    /**
     * get the name of a room for a Java client
     * unaware of CORBA
     */ 
    public String getName() {
	return name;
    }

    /**
     * reconstruct a Room using a CORBA orb in the target JVM
     */
    public Room getRoom(ORB orb) {
	if (corbaObj == null) {
	    return null;
	}
	org.omg.CORBA.Object obj = orb.string_to_object(corbaObj);
	Room r = RoomHelper.narrow(obj);
	return r;
    }

    /**
     * construct a portable Java representation of the CORBA
     * Room, using the CORBA orb on the source JVM
     */
    public JavaRoomImpl(Room r, ORB orb) {
	name = r.name();
	corbaObj = orb.object_to_string(r);
    }
    
    /**
     * construct a portable Java representation of the CORBA
     * Room, allowing access to data members but not
     * reconstruction of the CORBA reference
     */
    public JavaRoomImpl(Room r) {
	name = r.name();
	corbaObj = null;
    }
} // JavaRoomImpl
