
/**
 * @version 1.1
 *   changed getLease() to getRenewalSetLease() for Jini 1.1. beta
 */

package activation;

import java.rmi.activation.Activatable;
import java.rmi.activation.ActivationID;
import java.rmi.MarshalledObject;
import net.jini.core.event.RemoteEvent;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.lease.Lease;
import net.jini.lease.ExpirationWarningEvent;

public class RenewLease extends Activatable
    implements RemoteEventListener {
    
    public RenewLease(ActivationID id, MarshalledObject data)  
	throws java.rmi.RemoteException {
	super(id, 0);
    }
    
    public void notify(RemoteEvent evt) {
	System.out.println("expiring... " + evt.toString());
	ExpirationWarningEvent eevt = (ExpirationWarningEvent) evt;
	Lease lease = eevt.getRenewalSetLease();
	try {
	    // This is short, for testing. Try 2+ hours
	    lease.renew(20000L);
	} catch(Exception e) {
	    e.printStackTrace();
	}
	System.out.println("Lease renewed for " +
			   (lease.getExpiration() -
			    System.currentTimeMillis()));
    }
}
