/*
 * Decompiled with CFR 0.152.
 */
package filedir;

import common.Directory;
import http.HttpMP3SourceImpl;
import http.HttpOggSourceImpl;
import http.HttpSourceImpl;
import http.HttpWAVSourceImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import java.rmi.RMISecurityManager;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.ExportException;
import java.util.Vector;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationProvider;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceID;
import net.jini.discovery.DiscoveryManagement;
import net.jini.discovery.LookupDiscovery;
import net.jini.discovery.LookupDiscoveryManager;
import net.jini.export.Exporter;
import net.jini.id.Uuid;
import net.jini.id.UuidFactory;
import net.jini.lease.LeaseRenewalManager;
import net.jini.lookup.JoinManager;
import net.jini.lookup.ServiceIDListener;
import net.jini.lookup.entry.Name;

public class FileDirectory
implements Directory,
ServiceIDListener {
    private ServiceID[] serviceIDs;
    protected Remote proxy;
    protected HttpSourceImpl impl;
    private Entry[] dirEntries;
    private String cdInfo;
    private URL url = null;
    private Exporter exporter = null;
    private ServiceID serviceID = null;
    private String cdIndexDiscID;
    private String cddbDiscID;
    private URL[] trackURLs;
    private String[] trackNames;
    private Configuration config;
    private File serviceIDFile;
    private JoinManager[] joinMgrs;
    private JoinManager dirJoinMgr;
    private LeaseRenewalManager leaseRenewalManager;
    private Vector sources = new Vector();
    static /* synthetic */ Class array$Lnet$jini$core$entry$Entry;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$Ljava$net$URL;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$java$io$File;
    static /* synthetic */ Class class$net$jini$export$Exporter;

    public FileDirectory(String string, LeaseRenewalManager leaseRenewalManager) {
        this.leaseRenewalManager = leaseRenewalManager;
        this.getConfiguration(string);
        this.cdInfo = this.getCDInfo();
        this.joinMgrs = new JoinManager[this.trackURLs.length];
        for (int i = 0; i < this.trackURLs.length; ++i) {
            this.makeFileService(i, this.trackURLs[i]);
        }
        this.makeDirService();
    }

    public ServiceID[] getServiceIDs() throws RemoteException {
        return this.serviceIDs;
    }

    private void getConfiguration(String string) {
        Class clazz;
        String[] stringArray = new String[]{string};
        try {
            this.config = ConfigurationProvider.getInstance((String[])stringArray);
        }
        catch (Exception exception) {
            System.err.println(exception.toString());
            exception.printStackTrace();
            System.exit(1);
        }
        try {
            clazz = array$Lnet$jini$core$entry$Entry == null ? (array$Lnet$jini$core$entry$Entry = FileDirectory.class$("[Lnet.jini.core.entry.Entry;")) : array$Lnet$jini$core$entry$Entry;
            System.out.println(clazz.toString());
            this.dirEntries = (Entry[])this.config.getEntry("HttpFileSourceServer", "entries", clazz, null);
        }
        catch (Exception exception) {
            System.err.println("Config error: " + exception.toString());
        }
        try {
            this.cdIndexDiscID = (String)this.config.getEntry("HttpFileSourceServer", "cdIndexDiscID", class$java$lang$String == null ? (class$java$lang$String = FileDirectory.class$("java.lang.String")) : class$java$lang$String, null);
        }
        catch (Exception exception) {
            System.err.println("Config error: " + exception.toString());
        }
        try {
            this.cddbDiscID = (String)this.config.getEntry("HttpFileSourceServer", "cddbDiscID", class$java$lang$String == null ? (class$java$lang$String = FileDirectory.class$("java.lang.String")) : class$java$lang$String, null);
        }
        catch (Exception exception) {
            System.err.println("Config error: " + exception.toString());
        }
        try {
            clazz = array$Ljava$net$URL == null ? (array$Ljava$net$URL = FileDirectory.class$("[Ljava.net.URL;")) : array$Ljava$net$URL;
            System.out.println(clazz.toString());
            this.trackURLs = (URL[])this.config.getEntry("HttpFileSourceServer", "trackURLs", clazz, null);
        }
        catch (Exception exception) {
            System.err.println("Config error: " + exception.toString());
        }
        try {
            clazz = array$Ljava$lang$String == null ? (array$Ljava$lang$String = FileDirectory.class$("[Ljava.lang.String;")) : array$Ljava$lang$String;
            System.out.println(clazz.toString());
            this.trackNames = (String[])this.config.getEntry("HttpFileSourceServer", "trackNames", clazz, null);
        }
        catch (Exception exception) {
            System.err.println("Config error: " + exception.toString());
        }
        try {
            this.serviceIDFile = (File)this.config.getEntry("HttpFileSourceServer", "serviceIDFile", class$java$io$File == null ? (class$java$io$File = FileDirectory.class$("java.io.File")) : class$java$io$File, null);
            if (this.serviceIDFile != null) {
                this.getOrMakeServiceIDs(this.serviceIDFile);
            }
        }
        catch (Exception exception) {
            System.err.println("Config error: " + exception.toString());
        }
    }

    private void getOrMakeServiceIDs(File file) {
        this.serviceIDs = new ServiceID[this.trackURLs.length];
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file));
            this.serviceID = (ServiceID)objectInputStream.readObject();
            for (int i = 0; i < this.trackURLs.length; ++i) {
                this.serviceIDs[i] = (ServiceID)objectInputStream.readObject();
                System.out.println("Got service id " + this.serviceIDs[i]);
            }
        }
        catch (Exception exception) {
            System.out.println("Couldn't get service IDs - generating new ones");
            try {
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(file));
                Uuid uuid = UuidFactory.generate();
                this.serviceID = new ServiceID(uuid.getMostSignificantBits(), uuid.getLeastSignificantBits());
                objectOutputStream.writeObject(this.serviceID);
                for (int i = 0; i < this.serviceIDs.length; ++i) {
                    Uuid uuid2 = UuidFactory.generate();
                    ServiceID serviceID = new ServiceID(uuid2.getMostSignificantBits(), uuid2.getLeastSignificantBits());
                    objectOutputStream.writeObject(serviceID);
                    this.serviceIDs[i] = serviceID;
                    System.out.println("Generating service id " + this.serviceIDs[i]);
                }
            }
            catch (Exception exception2) {
                System.out.println("Couldn't save ids");
                exception2.printStackTrace();
            }
        }
    }

    private void makeDirService() {
        try {
            this.exporter = (Exporter)this.config.getEntry("HttpFileSourceServer", "exporter", class$net$jini$export$Exporter == null ? (class$net$jini$export$Exporter = FileDirectory.class$("net.jini.export.Exporter")) : class$net$jini$export$Exporter);
        }
        catch (Exception exception) {
            System.err.println(exception.toString());
            exception.printStackTrace();
            System.exit(1);
        }
        try {
            System.out.println("Export dir using exporter " + this.exporter);
            this.proxy = this.exporter.export((Remote)this);
        }
        catch (ExportException exportException) {
            System.err.println(exportException.toString());
            exportException.printStackTrace();
            System.exit(1);
        }
        this.dirJoinMgr = this.registerService(this.proxy, this.serviceID, this.dirEntries);
    }

    private void makeFileService(int n, URL uRL) {
        Exporter exporter;
        block10: {
            exporter = null;
            try {
                exporter = (Exporter)this.config.getEntry("HttpFileSourceServer", "exporter", class$net$jini$export$Exporter == null ? (class$net$jini$export$Exporter = FileDirectory.class$("net.jini.export.Exporter")) : class$net$jini$export$Exporter);
            }
            catch (Exception exception) {
                System.err.println(exception.toString());
                exception.printStackTrace();
                System.exit(1);
            }
            String string = uRL.toString();
            System.out.println("URL is " + string);
            try {
                if (string.endsWith("wav")) {
                    this.impl = new HttpWAVSourceImpl(uRL);
                    break block10;
                }
                if (string.endsWith("mp3")) {
                    this.impl = new HttpMP3SourceImpl(uRL);
                    break block10;
                }
                if (string.endsWith("ogg")) {
                    this.impl = new HttpOggSourceImpl(uRL);
                    break block10;
                }
                System.out.println("Can't handle presentation type: " + uRL);
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
        System.out.println("Source type: " + this.impl);
        Class<?>[] classArray = this.impl.getClass().getInterfaces();
        System.out.println("Ifaces: " + classArray.length);
        for (int i = 0; i < classArray.length; ++i) {
            System.out.println("" + classArray[i]);
        }
        this.sources.add(this.impl);
        try {
            System.out.println("Export file " + uRL + " using exporter " + exporter);
            this.proxy = exporter.export((Remote)this.impl);
        }
        catch (ExportException exportException) {
            System.err.println(exportException.toString());
            exportException.printStackTrace();
            System.exit(1);
        }
        String string = this.getTrackInfo(n);
        Entry[] entryArray = new Entry[]{new Name(string)};
        this.joinMgrs[n] = this.registerService(this.proxy, this.serviceIDs[n], entryArray);
    }

    private JoinManager registerService(Remote remote, ServiceID serviceID, Entry[] entryArray) {
        JoinManager joinManager = null;
        try {
            LookupDiscoveryManager lookupDiscoveryManager = new LookupDiscoveryManager(LookupDiscovery.ALL_GROUPS, null, null);
            if (serviceID != null) {
                System.out.println("Registering with id " + serviceID);
                joinManager = new JoinManager((Object)remote, entryArray, serviceID, (DiscoveryManagement)lookupDiscoveryManager, this.leaseRenewalManager);
            } else {
                joinManager = new JoinManager((Object)remote, entryArray, (ServiceIDListener)this, (DiscoveryManagement)lookupDiscoveryManager, this.leaseRenewalManager);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        return joinManager;
    }

    public void serviceIDNotify(ServiceID serviceID) {
        System.out.println("got service ID " + serviceID.toString());
    }

    public String getTrackInfo(int n) {
        if (this.trackNames != null && this.trackNames.length > n && this.trackNames[n] != null) {
            return this.cdInfo + ": " + this.trackNames[n];
        }
        String string = null;
        string = n < 9 ? "0" + (n + 1) : "" + (n + 1);
        return this.cdInfo + ": Track " + string;
    }

    public String getCDInfo() {
        for (int i = 0; i < this.dirEntries.length; ++i) {
            if (!(this.dirEntries[i] instanceof Name)) continue;
            return ((Name)this.dirEntries[i]).name;
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        Object object;
        LeaseRenewalManager leaseRenewalManager = new LeaseRenewalManager();
        System.setSecurityManager(new RMISecurityManager());
        FileDirectory fileDirectory = new FileDirectory(stringArray[0], leaseRenewalManager);
        Object object2 = object = new Object();
        synchronized (object2) {
            try {
                object.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

