/*
 * Decompiled with CFR 0.152.
 */
package client;

import client.ClientFrame;
import client.PlayFrame;
import common.Directory;
import common.Sink;
import common.Source;
import java.rmi.RMISecurityManager;
import java.rmi.Remote;
import java.rmi.RemoteException;
import javax.swing.tree.DefaultMutableTreeNode;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationProvider;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceTemplate;
import net.jini.discovery.DiscoveryManagement;
import net.jini.discovery.LookupDiscovery;
import net.jini.discovery.LookupDiscoveryManager;
import net.jini.export.Exporter;
import net.jini.lease.LeaseRenewalManager;
import net.jini.lookup.LookupCache;
import net.jini.lookup.ServiceDiscoveryEvent;
import net.jini.lookup.ServiceDiscoveryListener;
import net.jini.lookup.ServiceDiscoveryManager;
import net.jini.lookup.ServiceItemFilter;

public class GUIClient
implements ServiceDiscoveryListener {
    private ClientFrame clientFrame;
    private LookupCache cache;
    private static String CONFIG_FILE = "jeri/http_sink_server.config";
    static /* synthetic */ Class class$net$jini$export$Exporter;

    public static void main(String[] stringArray) {
        ClientFrame clientFrame = new ClientFrame();
        GUIClient gUIClient = new GUIClient(clientFrame);
        clientFrame.setClient(gUIClient);
        clientFrame.setSize(600, 600);
        clientFrame.setVisible(true);
    }

    public GUIClient(ClientFrame clientFrame) {
        LookupDiscoveryManager lookupDiscoveryManager;
        this.clientFrame = clientFrame;
        ServiceDiscoveryManager serviceDiscoveryManager = null;
        System.setSecurityManager(new RMISecurityManager());
        try {
            lookupDiscoveryManager = new LookupDiscoveryManager(LookupDiscovery.ALL_GROUPS, null, null);
            serviceDiscoveryManager = new ServiceDiscoveryManager((DiscoveryManagement)lookupDiscoveryManager, new LeaseRenewalManager());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
        lookupDiscoveryManager = new ServiceTemplate(null, null, null);
        try {
            this.cache = serviceDiscoveryManager.createLookupCache((ServiceTemplate)lookupDiscoveryManager, null, (ServiceDiscoveryListener)this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
        }
    }

    public void serviceAdded(ServiceDiscoveryEvent serviceDiscoveryEvent) {
        ServiceItem serviceItem = serviceDiscoveryEvent.getPostEventServiceItem();
        System.out.println("Service appeared: " + serviceItem.service.getClass().toString());
        if (serviceItem.service instanceof Directory) {
            System.out.println("  is dir");
            this.addDirectory(serviceItem);
        }
        if (serviceItem.service instanceof Sink) {
            System.out.println("  is sink");
            this.clientFrame.addSink(serviceItem);
        }
        if (serviceItem.service instanceof Source) {
            System.out.println("  is source");
            this.clientFrame.addSource(serviceItem);
        }
    }

    public void serviceChanged(ServiceDiscoveryEvent serviceDiscoveryEvent) {
        ServiceItem serviceItem = serviceDiscoveryEvent.getPostEventServiceItem();
        ServiceItem serviceItem2 = serviceDiscoveryEvent.getPreEventServiceItem();
        System.out.println("Service changed: " + serviceItem2.service.getClass().toString());
    }

    public void serviceRemoved(ServiceDiscoveryEvent serviceDiscoveryEvent) {
        ServiceItem serviceItem = serviceDiscoveryEvent.getPreEventServiceItem();
        System.out.println("Service disappeared: " + serviceItem.service.getClass().toString());
        if (serviceItem.service instanceof Directory) {
            System.out.println("  was dir");
            this.clientFrame.removeDirectory(serviceItem);
        }
        if (serviceItem.service instanceof Sink) {
            System.out.println("  was sink");
            this.clientFrame.removeSink(serviceItem);
        }
        if (serviceItem.service instanceof Source) {
            System.out.println("  was source");
            this.clientFrame.removeSource(serviceItem);
        }
    }

    private void addDirectory(ServiceItem serviceItem) {
        DefaultMutableTreeNode defaultMutableTreeNode = this.clientFrame.addDirectory(serviceItem);
        ServiceID[] serviceIDArray = null;
        try {
            serviceIDArray = ((Directory)serviceItem.service).getServiceIDs();
        }
        catch (RemoteException remoteException) {
            System.err.println(remoteException.toString());
            return;
        }
        for (int i = 0; i < serviceIDArray.length; ++i) {
            final ServiceID serviceID = serviceIDArray[i];
            ServiceItemFilter serviceItemFilter = new ServiceItemFilter(){

                public boolean check(ServiceItem serviceItem) {
                    return serviceItem.serviceID.equals((Object)serviceID);
                }
            };
            ServiceItem serviceItem2 = this.cache.lookup(serviceItemFilter);
            if (serviceItem2 == null) continue;
            this.clientFrame.addDirectoryElement(defaultMutableTreeNode, serviceItem2);
        }
    }

    public Remote export(PlayFrame playFrame) {
        String[] stringArray = new String[]{CONFIG_FILE};
        try {
            Configuration configuration = ConfigurationProvider.getInstance((String[])stringArray);
            Exporter exporter = (Exporter)configuration.getEntry("HttpSinkServer", "exporter", class$net$jini$export$Exporter == null ? (class$net$jini$export$Exporter = GUIClient.class$("net.jini.export.Exporter")) : class$net$jini$export$Exporter);
            Remote remote = exporter.export((Remote)((Object)playFrame));
            return remote;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

