/*
 * Decompiled with CFR 0.152.
 */
package jnlp;

import common.FileClassifier;
import common.MIMEType;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.core.lookup.ServiceTemplate;
import net.jini.discovery.DiscoveryEvent;
import net.jini.discovery.DiscoveryListener;
import net.jini.discovery.DiscoveryManagement;
import net.jini.discovery.LookupLocatorDiscovery;
import net.jini.lease.LeaseRenewalManager;
import net.jini.lookup.LookupCache;
import net.jini.lookup.ServiceDiscoveryManager;

public class FileClassifierApplication
extends JFrame
implements DiscoveryListener {
    private static final long WAITFOR = 50000L;
    ServiceItem item;
    TextField text;
    FileClassifier classifier;
    LookupCache cache;
    static /* synthetic */ Class class$common$FileClassifier;

    public static void main(String[] argv) {
        System.out.println("Found and starting");
        new FileClassifierApplication();
    }

    public FileClassifierApplication() {
        this.cacheFileClassifierService();
        Container contentPane = this.getContentPane();
        Panel top = new Panel();
        Panel bottom = new Panel();
        contentPane.add((Component)top, "Center");
        contentPane.add((Component)bottom, "South");
        top.setLayout(new BorderLayout());
        top.add((Component)new Label("Filename"), "West");
        this.text = new TextField(20);
        top.add((Component)this.text, "Center");
        bottom.setLayout(new FlowLayout());
        Button classify = new Button("Classify");
        Button quit = new Button("Quit");
        bottom.add(classify);
        bottom.add(quit);
        quit.addActionListener(new QuitListener());
        classify.addActionListener(new ClassifyListener());
        this.pack();
        this.setVisible(true);
    }

    protected void cacheFileClassifierService() {
        ServiceDiscoveryManager clientMgr = null;
        LookupLocatorDiscovery discovery = null;
        LookupLocator[] locators = null;
        System.setProperty("java.rmi.server.codebase", System.getProperty("codebase"));
        System.setSecurityManager(new RMISecurityManager());
        try {
            locators = this.getLocators();
            discovery = new LookupLocatorDiscovery(locators);
            clientMgr = new ServiceDiscoveryManager((DiscoveryManagement)discovery, new LeaseRenewalManager());
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        Class[] classes = new Class[]{class$common$FileClassifier == null ? (class$common$FileClassifier = FileClassifierApplication.class$("common.FileClassifier")) : class$common$FileClassifier};
        ServiceTemplate template = new ServiceTemplate(null, classes, null);
        try {
            this.cache = clientMgr.createLookupCache(template, null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    protected LookupLocator[] getLocators() {
        Vector<String> lookupNames = new Vector<String>();
        String lookupStr = System.getProperty("LookupServices");
        if (lookupStr == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(lookupStr);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            lookupNames.add(token);
        }
        LookupLocator[] locators = new LookupLocator[lookupNames.size()];
        for (int n = 0; n < locators.length; ++n) {
            LookupLocator loc = null;
            try {
                loc = new LookupLocator((String)lookupNames.elementAt(n));
            }
            catch (Exception e) {
                // empty catch block
            }
            locators[n] = loc;
        }
        return locators;
    }

    public void discovered(DiscoveryEvent e) {
        System.out.println("discovered");
        ServiceRegistrar[] registrars = e.getRegistrars();
        for (int n = 0; n < registrars.length; ++n) {
            ServiceRegistrar reg = registrars[n];
            try {
                System.out.println("  discovered " + reg.getLocator().getHost());
                continue;
            }
            catch (RemoteException ex) {
                // empty catch block
            }
        }
    }

    public void discarded(DiscoveryEvent e) {
        System.out.println("discarded");
        ServiceRegistrar[] registrars = e.getRegistrars();
        for (int n = 0; n < registrars.length; ++n) {
            ServiceRegistrar reg = registrars[n];
            try {
                System.out.println("  discarded " + reg.getLocator().getHost());
                continue;
            }
            catch (RemoteException ex) {
                // empty catch block
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class ClassifyListener
    implements ActionListener {
        ClassifyListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            String fileName = FileClassifierApplication.this.text.getText();
            Container frame = FileClassifierApplication.this.text.getParent();
            while (!(frame instanceof Frame)) {
                frame = frame.getParent();
            }
            Dialog dlg = new Dialog((Frame)frame);
            dlg.setLayout(new BorderLayout());
            TextArea response = new TextArea(3, 20);
            ServiceItem item = null;
            item = FileClassifierApplication.this.cache.lookup(null);
            if (item == null) {
                JOptionPane.showMessageDialog(null, "No service available");
                return;
            }
            FileClassifier classifier = (FileClassifier)item.service;
            MIMEType type = null;
            try {
                type = classifier.getMIMEType(fileName);
                if (type == null) {
                    response.setText("The type of file " + fileName + " is unknown");
                } else {
                    response.setText("The type of file " + fileName + " is " + type.toString());
                }
            }
            catch (RemoteException e) {
                response.setText(e.toString());
            }
            Button ok = new Button("ok");
            ok.addActionListener(new ActionListener(this, dlg){
                private final /* synthetic */ Dialog val$dlg;
                private final /* synthetic */ ClassifyListener this$1;
                {
                    this.this$1 = this$1;
                    this.val$dlg = val$dlg;
                }

                public void actionPerformed(ActionEvent e) {
                    this.val$dlg.setVisible(false);
                }
            });
            dlg.add((Component)response, "Center");
            dlg.add((Component)ok, "South");
            dlg.setSize(300, 100);
            dlg.setVisible(true);
        }
    }

    class QuitListener
    implements ActionListener {
        QuitListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            System.exit(0);
        }
    }
}

