/*
 * Decompiled with CFR 0.152.
 */
package ejb;

import common.MIMEType;
import ejb.FileClassifier;
import ejb.FileClassifierHome;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import rmi.RemoteFileClassifier;

public class FileClassifierImpl
extends UnicastRemoteObject
implements RemoteFileClassifier {
    private String user = null;
    private String password = "";
    private String url = "t3://localhost:7001";
    private FileClassifier classifier;

    public FileClassifierImpl(String[] args) throws RemoteException {
        this.parseArgs(args);
        try {
            Context ctx = this.getInitialContext();
            FileClassifierHome home = (FileClassifierHome)ctx.lookup("ejb.FileClassifierHome");
            this.classifier = home.create();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public MIMEType getMIMEType(String fileName) throws RemoteException {
        return this.classifier.getMIMEType(fileName);
    }

    private void parseArgs(String[] args) {
        if (args == null || args.length == 0) {
            return;
        }
        int n = 0;
        while (n < args.length) {
            if (args[n].equals("-url")) {
                this.url = args[++n];
            } else if (args[n].equals("-user")) {
                this.user = args[++n];
            } else if (args[n].equals("-password")) {
                this.password = args[++n];
            }
            ++n;
        }
    }

    private Context getInitialContext() throws Exception {
        Properties props = new Properties();
        ((Hashtable)props).put("java.naming.factory.initial", "weblogic.jndi.T3InitialContextFactory");
        ((Hashtable)props).put("java.naming.provider.url", this.url);
        if (this.user != null) {
            ((Hashtable)props).put("java.naming.security.principal", this.user);
            ((Hashtable)props).put("java.naming.security.credentials", this.password);
        }
        return new InitialContext(props);
    }
}

