/*
 * Decompiled with CFR 0.152.
 */
package ejb;

import ejb.FileClassifier;
import ejb.FileClassifierHome;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;

public class FileClassifierClient {
    private String user = null;
    private String password = "";
    private String url = "t3://localhost:7001";

    public static void main(String[] args) {
        new FileClassifierClient(args);
    }

    public FileClassifierClient(String[] args) {
        this.parseArgs(args);
        try {
            Context ctx = this.getInitialContext();
            FileClassifierHome home = (FileClassifierHome)ctx.lookup("ejb.FileClassifierHome");
            FileClassifier classifier = home.create();
            System.out.println("Type of file a.txt is " + classifier.getMIMEType("a.txt").toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void parseArgs(String[] args) {
        if (args == null || args.length == 0) {
            return;
        }
        int n = 0;
        while (n < args.length) {
            if (args[n].equals("-url")) {
                this.url = args[++n];
            } else if (args[n].equals("-user")) {
                this.user = args[++n];
            } else if (args[n].equals("-password")) {
                this.password = args[++n];
            }
            ++n;
        }
    }

    private Context getInitialContext() throws Exception {
        Properties props = new Properties();
        ((Hashtable)props).put("java.naming.factory.initial", "weblogic.jndi.T3InitialContextFactory");
        ((Hashtable)props).put("java.naming.provider.url", this.url);
        if (this.user != null) {
            ((Hashtable)props).put("java.naming.security.principal", this.user);
            ((Hashtable)props).put("java.naming.security.credentials", this.password);
        }
        return new InitialContext(props);
    }
}

