/******************************************************************
*
*	CyberUPnP for Java
*
*	Copyright (C) Satoshi Konno 2002
*
*	File: Advertiser.java
*
*	Revision;
*
*	12/24/03
*		- first revision.
*	
******************************************************************/

package org.cybergarage.upnp.device;

import org.cybergarage.util.*;
import org.cybergarage.upnp.*;

public class Advertiser extends ThreadCore
{
	////////////////////////////////////////////////
	//	Constructor
	////////////////////////////////////////////////

	public Advertiser(Device dev)
	{
		setDevice(dev);
	}
	
	////////////////////////////////////////////////
	//	Member
	////////////////////////////////////////////////

	private Device device;

	public void setDevice(Device dev)
	{
		device = dev;
	}
	
	public Device getDevice()
	{
		return device;
	}

	////////////////////////////////////////////////
	//	Thread
	////////////////////////////////////////////////
	
	public void run() 
	{
		Device dev = getDevice();
		long notifyInterval = dev.getLeaseTime();
		if (UPnP.DEFAULT_EXPIRED_DEVICE_EXTRA_TIME < notifyInterval)
			notifyInterval -= UPnP.DEFAULT_EXPIRED_DEVICE_EXTRA_TIME;
		notifyInterval *= 1000;
		
		while (isRunnable() == true) {
			try {
				Thread.sleep(notifyInterval);
			} catch (InterruptedException e) {}
			dev.announce();
		}
	}
}
