/******************************************************************
*
*	CyberUPnP for Java
*
*	Copyright (C) Satoshi Konno 2002
*
*	File: Argument.java
*
*	Revision;
*
*	12/05/02
*		- first revision.
*	
******************************************************************/

package org.cybergarage.upnp;

import org.cybergarage.xml.*;

import org.cybergarage.upnp.xml.*;

public class Argument
{
	////////////////////////////////////////////////
	//	Constants
	////////////////////////////////////////////////
	
	public final static String ELEM_NAME = "argument";

	public final static String IN = "in";
	public final static String OUT = "out";

	////////////////////////////////////////////////
	//	Member
	////////////////////////////////////////////////

	private Node argumentNode;

	public Node getArgumentNode()
	{
		return argumentNode;
	}
	
	////////////////////////////////////////////////
	//	Constructor
	////////////////////////////////////////////////

	public Argument()
	{
		argumentNode = new Node();
	}
	
	public Argument(Node node)
	{
		argumentNode = node;
	}

	public Argument(String name, String value)
	{
		this();
		setName(name);
		setValue(value);
	}

	////////////////////////////////////////////////
	//	isArgumentNode
	////////////////////////////////////////////////

	public static boolean isArgumentNode(Node node)
	{
		return Argument.ELEM_NAME.equals(node.getName());
	}

	////////////////////////////////////////////////
	//	name
	////////////////////////////////////////////////

	private final static String NAME = "name";
	
	public void setName(String value)
	{
		getArgumentNode().setNode(NAME, value);
	}

	public String getName()
	{
		return getArgumentNode().getNodeValue(NAME);
	}

	////////////////////////////////////////////////
	//	direction
	////////////////////////////////////////////////

	private final static String DIRECTION = "direction";
	
	public void setDirection(String value)
	{
		getArgumentNode().setNode(DIRECTION, value);
	}

	public String getDirection()
	{
		return getArgumentNode().getNodeValue(DIRECTION);
	}

	public boolean isInDirection()
	{
		String dir = getDirection();
		if (dir == null)
			return false;
		return dir.equalsIgnoreCase(IN);
	}

	public boolean isOutDirection()
	{
		return !isInDirection();
	}
	
	////////////////////////////////////////////////
	//	relatedStateVariable
	////////////////////////////////////////////////

	private final static String RELATED_STATE_VARIABLE = "relatedStateVariable";
	
	public void setRelatedStateVariable(String value)
	{
		getArgumentNode().setNode(RELATED_STATE_VARIABLE, value);
	}

	public String getRelatedStateVariable()
	{
		return getArgumentNode().getNodeValue(RELATED_STATE_VARIABLE);
	}

	////////////////////////////////////////////////
	//	UserData
	////////////////////////////////////////////////

	private ArgumentData getArgumentData()
	{
		Node node = getArgumentNode();
		ArgumentData userData = (ArgumentData)node.getUserData();
		if (userData == null) {
			userData = new ArgumentData();
			node.setUserData(userData);
			userData.setNode(node);
		}
		return userData;
	}

	////////////////////////////////////////////////
	//	value
	////////////////////////////////////////////////

	public void setValue(String value) 
	{
		getArgumentData().setValue(value);
	}
	
	public void setValue(int value) 
	{
		setValue(Integer.toString(value));
	}
	
	public String getValue() 
	{
		return getArgumentData().getValue();
	}

	public int getIntegerValue() 
	{
		String value = getValue();
		try {
			return Integer.parseInt(value);
		}
		catch (Exception e) {
		}
		return 0;
	}

}
