/******************************************************************
*
*	CyberHTTP for Java
*
*	Copyright (C) Satoshi Konno 2002
*
*	File: HTTPStatus.java
*
*	Revision;
*
*	12/17/02
*		- first revision.
*	09/03/03
*		- Added CONTINUE_STATUS.
*	
******************************************************************/

package org.cybergarage.http;

import java.util.*;

import org.cybergarage.util.*;

public class HTTPStatus 
{
	////////////////////////////////////////////////
	//	Code
	////////////////////////////////////////////////
	
	public static final int CONTINUE_STATUS = 100;
	public static final int OK = 200;
	public static final int BAD_REQUEST = 400;
	public static final int NOT_FOUND = 404;
	public static final int PRECONDITION_FAILED = 412;
	public static final int INTERNAL_SERVER_ERROR = 500;

	public static final String code2String(int code)
	{
		switch (code) {
		case OK: return "OK";
		case BAD_REQUEST: return "Bad Request";
		case PRECONDITION_FAILED: return "Precondition Failed";
		case INTERNAL_SERVER_ERROR: return "Internal Server Error";
		}
		 return "";
	}
 	
	////////////////////////////////////////////////
	//	Constructor
	////////////////////////////////////////////////

	public HTTPStatus()
	{
		setVersion("");
		setStatusCode(0);
		setReasonPhrase("");
	}
	
	public HTTPStatus(String ver, int code, String reason)
	{
		setVersion(ver);
		setStatusCode(code);
		setReasonPhrase(reason);
	}

	public HTTPStatus(String lineStr)
	{
		set(lineStr);
	}
	
	////////////////////////////////////////////////
	//	Member
	////////////////////////////////////////////////

	private String version = "";
	private int statusCode = 0;
	private String reasonPhrase = "";

	public void setVersion(String value)
	{
		version = value;
	}
	
	public void setStatusCode(int value)
	{
		statusCode = value;
	}
	
	public void setReasonPhrase(String value)
	{
		reasonPhrase = value;
	}
	
	public String getVersion()
	{
		return version;
	}
	
	public int getStatusCode()
	{
		return statusCode;
	}
	
	public String getReasonPhrase()
	{
		return reasonPhrase;
	}

	public void set(String lineStr)
	{
		if (lineStr == null) {
			setVersion(HTTP.VERSION);
			setStatusCode(INTERNAL_SERVER_ERROR);
			setReasonPhrase(code2String(INTERNAL_SERVER_ERROR));
			return;
		}

		try {
			StringTokenizer st = new StringTokenizer(lineStr, HTTP.STATUS_LINE_DELIM);
		
			if (st.hasMoreTokens() == false)
				return;
			String ver = st.nextToken();
			if (st.hasMoreTokens() == false)
				return;
			String codeStr = st.nextToken();
			int code = 0;
			try {
				code = Integer.parseInt(codeStr);
			}
			catch (Exception e1) {}
			if (st.hasMoreTokens() == false)
				return;
			String reason = st.nextToken();
		
			setVersion(ver.trim());
			setStatusCode(code);
			setReasonPhrase(reason.trim());
		}
		catch (Exception e) {
			Debug.warning(e);
		}

	}
	
}
