/******************************************************************
*
*	CyberHTTP for Java
*
*	Copyright (C) Satoshi Konno 2002
*
*	File: HTTPHeader.java
*
*	Revision;
*
*	11/19/02
*		- first revision.
*	
******************************************************************/

package org.cybergarage.http;

import java.io.*;

import org.cybergarage.util.*;

public class HTTPHeader 
{
	private String name;
	private String value;

	public HTTPHeader(String name, String value)
	{
		setName(name);
		setValue(value);
	}

	public HTTPHeader(String lineStr)
	{
		setName("");
		setValue("");
		if (lineStr == null)
			return;
		int colonIdx = lineStr.indexOf(':');
		if (colonIdx < 0)
			return;
		String name = new String(lineStr.getBytes(), 0, colonIdx);				
		String value = new String(lineStr.getBytes(), colonIdx+1, lineStr.length()-colonIdx-1);				
		setName(name.trim());
		setValue(value.trim());
	}

	////////////////////////////////////////////////
	//	Member
	////////////////////////////////////////////////
	
	public void setName(String name)
	{
		this.name = name;
	}
		
	public void setValue(String value)
	{
		this.value = value;
	}

	public String getName()
	{
		return name;
	}

	public String getValue()
	{
		return value;
	}

	public boolean hasName()
	{
		if (name == null ||  name.length() <= 0)
			return false;
		return true;
	}
	
	////////////////////////////////////////////////
	//	static methods
	////////////////////////////////////////////////
	
	public final static String getValue(LineNumberReader reader, String name)
	{
		String bigName = name.toUpperCase();
		try {
			String lineStr = reader.readLine();
			while (lineStr != null && 0 < lineStr.length()) {
				HTTPHeader header = new HTTPHeader(lineStr);
				if (header.hasName() == false) {
					 lineStr = reader.readLine();
					continue;
				}
				String bigLineHeaderName = header.getName().toUpperCase();
				if (bigLineHeaderName.equals(bigName) == false) {
					 lineStr = reader.readLine();
					 continue;
				}
				return header.getValue();
			}
		}
		catch (IOException e) {
			Debug.warning(e);
			return "";
		}
		return "";
	}

	public final static String getValue(String data, String name)
	{
		StringReader strReader = new StringReader(data);
		LineNumberReader lineReader = new LineNumberReader(strReader);
		return getValue(lineReader, name);
	}

	public final static String getValue(byte[] data, String name)
	{
		return getValue(new String(data), name);
	}

	public final static int getIntegerValue(String data, String name)
	{
		try {
			return Integer.parseInt(getValue(data, name));
		}
		catch (Exception e) {
			return 0;
		}
	}

	public final static int getIntegerValue(byte[] data, String name)
	{
		try {
			return Integer.parseInt(getValue(data, name));
		}
		catch (Exception e) {
			return 0;
		}
	}
}
